/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 收入证明 中的 单位信息维护表
 *
 * @author fxj
 * @date 2023-08-23 17:31:05
 */
@Data
@TableName("t_company_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "收入证明 中的 单位信息维护表")
public class TCompanyInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 公司名称
	 */
	@ExcelAttribute(name = "公司名称", isNotEmpty = true, errorInfo = "公司名称不能为空", maxLength = 50)
	@NotBlank(message = "公司名称不能为空")
	@Length(max = 50, message = "公司名称不能超过50个字符")
	@ExcelProperty("公司名称")
	@Schema(description = "公司名称")
	private String companyName;
	/**
	 * 公司地址
	 */
	@ExcelAttribute(name = "公司地址", isNotEmpty = true, errorInfo = "公司地址不能为空", maxLength = 200)
	@NotBlank(message = "公司地址不能为空")
	@Length(max = 200, message = "公司地址不能超过200个字符")
	@ExcelProperty("公司地址")
	@Schema(description = "公司地址")
	private String companyAddress;
	/**
	 * 公司电话
	 */
	@ExcelAttribute(name = "公司电话", isNotEmpty = true, errorInfo = "公司电话不能为空", maxLength = 20)
	@NotBlank(message = "公司电话不能为空")
	@Length(max = 20, message = "公司电话不能超过20个字符")
	@ExcelProperty("公司电话")
	@Schema(description = "公司电话")
	private String companyTel;
	/**
	 * 创建人id
	 */
	@ExcelAttribute(name = "创建人id", isNotEmpty = true, errorInfo = "创建人id不能为空", maxLength = 32)
	@NotBlank(message = "创建人id不能为空")
	@Length(max = 32, message = "创建人id不能超过32个字符")
	@ExcelProperty("创建人id")
	@Schema(description = "创建人id")
	private String createBy;
	/**
	 * 创建人姓名
	 */
	@ExcelAttribute(name = "创建人姓名", maxLength = 32)
	@Length(max = 32, message = "创建人姓名不能超过32个字符")
	@ExcelProperty("创建人姓名")
	@Schema(description = "创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isNotEmpty = true, errorInfo = "创建时间不能为空", isDate = true)
	@NotBlank(message = "创建时间不能为空")
	@ExcelProperty("创建时间")
	@Schema(description = "创建时间")
	private LocalDateTime createTime;
	/**
	 * 更新人id
	 */
	@ExcelAttribute(name = "更新人id", maxLength = 32)
	@Length(max = 32, message = "更新人id不能超过32个字符")
	@ExcelProperty("更新人id")
	@Schema(description = "更新人id")
	private String updateBy;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@ExcelProperty("更新时间")
	@Schema(description = "更新时间")
	private LocalDateTime updateTime;
	/**
	 * 0 未删除 1 已删除
	 */
	@ExcelAttribute(name = "0 未删除 1 已删除", maxLength = 1)
	@Length(max = 1, message = "0 未删除 1 已删除不能超过1个字符")
	@ExcelProperty("0 未删除 1 已删除")
	@Schema(description = "0 未删除 1 已删除")
	private String deleteFlag;

}
