package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TEmployeeInsurancePreVo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 确认接受vo
 *
 * @author huych
 * @date 2025-03-12 17:14:19
 */
@Data
public class EmployeeRegistrationPreVo implements Serializable {

	/**
	 * 主键ID
	 */
	@Schema(description = "主键ID")
	private String id;

	@Schema(description = "员工类型（字典值，0外包1派遣2代理）")
	private String empNature;

	@Schema(description = "合同类型（字典值）")
	private String contractType;

	@Schema(description = "合同业务细分（字典值）")
	private String contractSubName;

	@Schema(description = "服务事项")
	private String serverItem;

	@Schema(description = "档案所在地-省")
	private String fileProvince;

	@Schema(description = "档案所在地-市")
	private String fileCity;

	@Schema(description = "档案所在地-县")
	private String fileTown;

	@Schema(description = "档案所在地-省编号")
	private String provinceCode;

	@Schema(description = "档案所在地-市编号")
	private String cityCode;

	@Schema(description = "档案所在地-县编号")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String townCode;


	@Schema(description = "员工姓名")
	private String employeeName;

	@Schema(description = "身份证号")
	private String empIdcard;

	@Schema(description = "手机号码")
	private String empPhone;

	@Schema(description = "就职岗位")
	private String position;

	@Schema(description = "入职日期")
	private Date joinLeaveDate;

	@Schema(description = "推送时间")
	private String pushDate;

	@Schema(description = "状态,0短信待发送,1信息待填写,2信息待审核,3拒绝入职,4已完成")
	private String processStatus;

	@Schema(description = "前端客服")
	private String customerUsername;

	@Schema(description = "前端客服登录名")
	private String customerUserLoginname;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description = "项目编码")
	private String deptNo;

	@Schema(description = "项目id")
	private String deptId;

	@Schema(description = "数据来源")
	private String dataSource;

	@Schema(description = "预计收集时间")
	private Date expectedCollectionTime;

	@Schema(description = "确认人")
	private String confirmUser;

	@Schema(description = "确认时间")
	private Date confirmTime;

	@Schema(description = "最新的客服名称")
	private String customerUsernameNew;

	@Schema(description = "创建人-姓名")
	private String createName;

	@Schema(description = "创建人")
	private String createBy;

	@Schema(description = "更新人")
	private String updateBy;

	@Schema(description = "身份证合集")
	private List<String> idcardList;

	@Schema(description = "商险待派单信息集合")
	private List<TEmployeeInsurancePreVo> employeeInsurancePreVos;

	@Schema(description = "附件集合")
	private List<TAttaInfoSaveVo> attaList;

}
