package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 流程路由条件
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_node_route_condition")
@Schema(description = "流程路由条件")
public class TNodeRouteCondition extends Model<TNodeRouteCondition> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
	 @Schema(description = "主键")
     private String id;

     @NotBlank(message = "条件字段不能为空")
     @Length(max = 255, message = "条件字段不能超过255个字符")
	 @Schema(description = "条件字段")
     private String field;

     @NotBlank(message = "判断条件：大于/等于/大于等于/小于/小于等于/不等于/包含/不包含不能为空")
     @Length(max = 255, message = "判断条件：大于/等于/大于等于/小于/小于等于/不等于/包含/不包含不能超过255个字符")
	 @Schema(description = "判断条件：大于/等于/大于等于/小于/小于等于/不等于/包含/不包含")
     private String conditions;

     @NotBlank(message = "参与判定的值（可能存在类型转换）不能为空")
     @Length(max = 255, message = "参与判定的值（可能存在类型转换）不能超过255个字符")
	 @Schema(description = "参与判定的值（可能存在类型转换）")
     private String conditionValue;

     @NotBlank(message = "与其他条件之间的关系（0没有关系或单独条件/1或的关系/2并且关系）不能为空")
     @Length(max = 1, message = "与其他条件之间的关系（0没有关系或单独条件/1或的关系/2并且关系）不能超过1个字符")
	 @Schema(description = "与其他条件之间的关系（0没有关系或单独条件/1或的关系/2并且关系）")
     private String realation;

     @NotBlank(message = "流程路由ID不能为空")
     @Length(max = 255, message = "流程路由ID不能超过255个字符")
	 @Schema(description = "流程路由ID")
     private String nodeRouteId;

     @NotBlank(message = "类型:1.正常条件 2.正则表达式'不能为空")
     @Length(max = 255, message = "类型:1.正常条件 2.正则表达式255个字符")
     @Schema(description = "类型:1.正常条件 2.正则表达式")
     private String type;
}
