package com.yifu.cloud.plus.v1.ekp.controller;

import com.icbc.api.response.JftApiPayrollQueryDetailResponseV1;
import com.yifu.cloud.plus.v1.ekp.service.IcbcTransactionFlowIssueService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankAttaReturnVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;

/**
 * 聚富通代发工资相关
 *
 * @author huyc
 * @date 2024-05-23 10:24:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/icbcIssue")
@Tag(name = "聚富通代发工资相关")
public class IcbcTransactionFlowIssueController {

	private final IcbcTransactionFlowIssueService icbcTransactionFlowIssueService;

	/**
	 * 聚富通代发工资确认提交
	 *
	 * @param
	 * @param
	 * @return
	 */
	@Operation(summary = "聚富通代发工资确认提交接口", description = "聚富通代发工资确认提交接口")
	@PostMapping("/submit")
	public R<String> submitIcbcTransactionFlow(@RequestParam(required = false) String totalAmt
			, @RequestParam(required = false) String totalCount, @RequestParam(required = false) String wxNo
			, @RequestParam(required = false) String url, @RequestParam(required = false) String mdCode) {
		if (Common.isEmpty(totalAmt) || !CommonConstants.ONE_STRING.equals(totalAmt)) {
			totalAmt = "1";
			totalCount = "1";
			wxNo = "WX202411201649110001732092551023";
			url = "020101190_WX202411201649110001732092551023_0_20241120.xls";
			mdCode = "49003789330801136756328772184671605624443424719041259624457722383503273821290";
		}
		return icbcTransactionFlowIssueService.submitIcbcTransactionFlow(totalAmt, totalCount, wxNo, url, mdCode);
	}

	/**
	 * 代发工资明细查询
	 *
	 * @param
	 * @param
	 * @return
	 */
	@Operation(summary = "代发工资明细查询", description = "代发工资明细查询")
	@PostMapping("/page")
	public JftApiPayrollQueryDetailResponseV1 selectIcbcTransactionFlowInfo(@RequestParam String wxNo
			, @RequestParam String startId, @RequestParam String endId) {
		return icbcTransactionFlowIssueService.selectIcbcTransactionFlowInfo(wxNo, startId, endId);
	}

	/**
	 * 代发工资发放成功异步通知功能
	 *
	 * @param
	 * @param
	 * @return
	 */
	@Operation(summary = "代发工资发放成功异步通知功能", description = "代发工资发放成功异步通知功能")
	@PostMapping("/notifyUrl")
	public R asyncNotice(HttpServletRequest request) throws Exception {
		return icbcTransactionFlowIssueService.asyncNotice(request);
	}

	/**
	 * 行名行号查询接口
	 *
	 * @param
	 * @param
	 * @return
	 */
	@Operation(summary = "行名行号查询接口---测试接口，实际接口用代发模块的查询接口", description = "行名行号查询接口")
	@PostMapping("/querybankinfo")
	public R querybankinfo() {
		return icbcTransactionFlowIssueService.querybankinfo();
	}

	/**
	 * @param fdId 主键ID
	 * @param type 类型 1：主表附件；2：明细表附件
	 * @Description: 下载代发任务附件
	 * @Author: hgw
	 * @Date: 2024/11/15 14:51
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.ekp.entity.EkpBankAtta>
	 **/
	@Operation(summary = "下载代发任务附件--EKP调用接口", description = "下载代发任务附件--EKP调用接口")
	@SysLog("下载代发任务附件--EKP调用接口")
	@GetMapping("/getIssueFileByFdId")
	public R<EkpBankAttaReturnVo> getIssueFileByFdId(@RequestParam String fdId, @RequestParam String type) {
		return icbcTransactionFlowIssueService.getIssueFileByFdId(fdId, type);
	}

	/**
	 * @param fdId 主键ID
	 * @param type 类型 1：主表附件；2：明细表附件
	 * @Description: 发放
	 * @Author: hgw
	 * @Date: 2024-11-22 11:32:21
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.ekp.entity.EkpBankAtta>
	 **/
	@Operation(summary = "发放银企付款--EKP调用接口", description = "发放银企付款--EKP调用接口")
	@SysLog("发放银企付款--EKP调用接口")
	@GetMapping("/submitBankTask")
	public R<String> submitBankTask(@RequestParam String fdId, @RequestParam String type, @RequestParam String submitUser) {
		return icbcTransactionFlowIssueService.submitBankTask(fdId, type, submitUser);
	}

	@Operation(description = "下载文件测试")
	@PostMapping("/exportAll")
	@SysLog("下载文件测试")
	public void exportAll(HttpServletResponse response) {
		icbcTransactionFlowIssueService.exportAll(response);
	}

	@Operation(summary = "每小时获取银企付款结果", description = "每小时获取银企付款结果")
	@Inner
	@PostMapping("/inner/doGetEkpBankStatus")
	public R<String> doGetEkpBankStatus() {
		return icbcTransactionFlowIssueService.doGetEkpBankStatus();
	}

	@Operation(summary = "定时任务获取回单文件", description = "定时任务获取回单文件")
	@Inner
	@PostMapping("/inner/getPdfFile")
	public R getPdfFile(){
		return icbcTransactionFlowIssueService.getPdfFile();
	}

	@Operation(summary = "定时任务获取回单文件", description = "定时任务获取回单文件")
	@PostMapping("/getTestPdfFile")
	public R getPdfFileTest()  {
		return icbcTransactionFlowIssueService.getPdfFile();
	}
}
