package com.yifu.cloud.plus.v1.ekp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.ekp.entity.EkpSalaryInfo;
import com.yifu.cloud.plus.v1.ekp.vo.ClaimRebackInfotVO;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialSumInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 工资明细表
 *
 * @author huyc
 * @date 2024-03-11 11:21:56
 */
@Mapper
public interface EkpSalaryInfoMapper extends BaseMapper<EkpSalaryInfo> {

	/**
	 * 获取所有项目信息
	 * @param
	 * @return
	 */
	List<EkpDeptInfoVo> getAllEkpDeptInfo();

	/**
	 * 根据身份证和生成月份获取费用合计
	 * @param
	 * @return
	 */
	EkpSocialSumInfoVo getCostSumInfo(@Param("card") String empIdCard, @Param("month") String createMonth);

	/**
	 * 根据项目编码查询款项认领明细
	 * @param
	 * @return
	 */
	ClaimRebackInfotVO getClaimInfoByDeptNo(@Param("deptNo") String deptNo,@Param("flag") String flag);

	/**
	 * 根据项目编码查询款项认领明细
	 * @param
	 * @return
	 */
	List<ClaimRebackInfotVO> getClaimBigInfoByDeptNoAndUser(@Param("deptNo") String deptNo);

}
