package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeReaderPromission;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodeReaderPromissionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * 流程审阅权限表（抄送/仅有查看权限）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tnodereaderpromission")
@Tag(name = "流程审阅权限表（抄送/仅有查看权限）")
public class TNodeReaderPromissionController {

	@Resource
     private TNodeReaderPromissionService tNodeReaderPromissionService;

     /**
      * 简单分页查询
      *
      * @param page                  分页对象
      * @param tNodeReaderPromission 流程审阅权限表（抄送/仅有查看权限）
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TNodeReaderPromission>> getTNodeReaderPromissionPage(Page<TNodeReaderPromission> page, TNodeReaderPromission tNodeReaderPromission) {
          return new R<>(tNodeReaderPromissionService.getTNodeReaderPromissionPage(page, tNodeReaderPromission));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TNodeReaderPromission> getById(@PathVariable("id") String id) {
          return new R<>(tNodeReaderPromissionService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tNodeReaderPromission
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TNodeReaderPromission tNodeReaderPromission) {
          return new R<>(tNodeReaderPromissionService.save(tNodeReaderPromission));
     }

     /**
      * 修改记录
      *
      * @param tNodeReaderPromission
      * @return R
      */
	 @Operation(summary = "修改(yifu-module:tnodereaderpromission_edit)")
     @SysLog("修改流程审阅权限表（抄送/仅有查看权限）")
     @PutMapping
     public R<Boolean> update(@RequestBody TNodeReaderPromission tNodeReaderPromission) {
          return new R<>(tNodeReaderPromissionService.updateById(tNodeReaderPromission));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除(yifu-module:tnodereaderpromission_del)")
     @SysLog("删除流程审阅权限表（抄送/仅有查看权限）")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tNodeReaderPromissionService.removeById(id));
     }

}
