/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author fxj
 * @date 2024-12-18 15:39:57
 */
@Data
public class TQuestionFeedbackInfoVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * 反馈人姓名
	 */
	@NotBlank(message = "反馈人姓名 不能为空")
	@Length(max = 20, message = "反馈人姓名 不能超过20 个字符")
	@ExcelAttribute(name = "反馈人姓名", isNotEmpty = true, errorInfo = "反馈人姓名 不能为空", maxLength = 20)
	@Schema(description = "反馈人姓名")
	@ExcelProperty("反馈人姓名")
	private String name;
	/**
	 * 手机号码
	 */
	@NotBlank(message = "手机号码 不能为空")
	@Length(max = 20, message = "手机号码 不能超过20 个字符")
	@ExcelAttribute(name = "手机号码", isNotEmpty = true, errorInfo = "手机号码 不能为空", maxLength = 20)
	@Schema(description = "手机号码")
	@ExcelProperty("手机号码")
	private String mobile;
	/**
	 * 你遇到的问题
	 */
	@Length(max = 200, message = "你遇到的问题 不能超过200 个字符")
	@ExcelAttribute(name = "你遇到的问题", maxLength = 200)
	@Schema(description = "你遇到的问题")
	@ExcelProperty("你遇到的问题")
	private String question;
	/**
	 * 处理状态：待处理、处理中、已处理、手动更新
	 */
	@Length(max = 10, message = "处理状态：待处理、处理中、已处理、手动更新 不能超过10 个字符")
	@ExcelAttribute(name = "处理状态：待处理、处理中、已处理、手动更新", maxLength = 10)
	@Schema(description = "处理状态：待处理、处理中、已处理、手动更新")
	@ExcelProperty("处理状态：待处理、处理中、已处理、手动更新")
	private String handleStatus;
	/**
	 * 处理人
	 */
	@Length(max = 20, message = "处理人 不能超过20 个字符")
	@ExcelAttribute(name = "处理人", maxLength = 20)
	@Schema(description = "处理人")
	@ExcelProperty("处理人")
	private String handleOperator;
	/**
	 * 处理完成时间
	 */
	@ExcelAttribute(name = "处理完成时间", isDate = true)
	@Schema(description = "处理完成时间")
	@ExcelProperty("处理完成时间")
	private Date handleFinishTime;
	/**
	 * 处理说明
	 */
	@Length(max = 200, message = "处理说明 不能超过200 个字符")
	@ExcelAttribute(name = "处理说明", maxLength = 200)
	@Schema(description = "处理说明")
	@ExcelProperty("处理说明")
	private String handleRemark;
	/**
	 * 创建人id
	 */
	@Length(max = 64, message = "创建人id 不能超过64 个字符")
	@ExcelAttribute(name = "创建人id", maxLength = 64)
	@Schema(description = "创建人id")
	@ExcelProperty("创建人id")
	private String createBy;
	/**
	 * 创建人姓名
	 */
	@Length(max = 64, message = "创建人姓名 不能超过64 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 64)
	@Schema(description = "创建人姓名")
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@Schema(description = "创建时间")
	@ExcelProperty("创建时间")
	private Date createTime;
	/**
	 * 更新人id
	 */
	@Length(max = 32, message = "更新人id 不能超过32 个字符")
	@ExcelAttribute(name = "更新人id", maxLength = 32)
	@Schema(description = "更新人id")
	@ExcelProperty("更新人id")
	private String updateBy;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@Schema(description = "更新时间")
	@ExcelProperty("更新时间")
	private Date updateTime;

}
