package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.service.SalaryUploadService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.HcmSalarySearchVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.SalaryUploadParamVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryDetailVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 标准薪酬上传
 *
 * @author hgw
 * @date 2019-9-4 11:59:33
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/salary")
@Tag(name = "标准薪酬上传")
public class SalaryUploadController {

	private final SalaryUploadService salaryUploadService;

	/**
	 * @param vo : jsonString   Excel表-JsonString;settleDepart 结算主体id;configId     配置方案id;salaryType   报表类型id
	 * @Description: 上传薪资表
	 * @Author: hgw
	 * @Date: 2019/9/11 15:21
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Operation(description = "上传：jsonString：表格json；settleDepart：结算主体id；configId：工资配置结算月等信息的id；salaryType：工资类型")
	@SysLog("上传薪资表")
	@PostMapping("/upload")
	public R<List<ErrorMessage>> upload(@RequestBody SalaryUploadParamVo vo) {
		return salaryUploadService.salaryUpload(vo);
	}

	@Operation(description = "打开结算单")
	@SysLog("打开结算单")
	@PostMapping("/openBill")
	public R<TSalaryDetailVo> openBill(@RequestParam String salaryFormId) {
		return salaryUploadService.getBill(salaryFormId);
	}

	/**
	 * @param vo ： idCardList 身份证list； salaryMonth 工资月
	 * @Description: HCM查询工资
	 * @Author: hgw
	 * @Date: 2025/5/20 20:26
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.baomidou.mybatisplus.core.metadata.IPage < com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>>
	 **/
	@Operation(description = "HCM查询工资")
	@PostMapping("/getHcmSalaryByIdCardListAndMonth")
	public R<List<TSalaryAccount>> getSalaryByIdCardList(@RequestBody HcmSalarySearchVo vo) {
		List<String> idCardList = vo.getIdCardList();
		String salaryMonth = vo.getSalaryMonth();
		if (Common.isEmpty(salaryMonth)) {
			return R.failed("工资月不可为空");
		}
		if (Common.isEmpty(idCardList) || idCardList.isEmpty()) {
			return R.failed("身份证不可为空");
		} else if (idCardList.size() > 3000) {
			return R.failed("身份证数不可大于3000！");
		}
		return new R<>(salaryUploadService.getSalaryByIdCardList(idCardList, salaryMonth));
	}

}
