/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 社保士兵Mapper
 * @author hgw
 * @date 2024-5-13 11:54:57
 */
@Mapper
public interface TSocialSoldierMapper extends BaseMapper<TSocialInfo> {
	/**
	 * 社保士兵养工失增加模板
	 * @Author hgw
	 * @Date 2024-5-10 21:16:41
	 **/
	List<SocialSoldierYgsAddVo> getSocialSoldierYgsAddVoList(@Param("idsStr") List<String> idsStr);
	/**
	 * 社保士兵养工失减少模板
	 * @Author hgw
	 * @Date 2024-5-10 21:16:41
	 **/
	List<SocialSoldierYgsAddVo> getSocialSoldierYgsReduceVoList(@Param("idsStr") List<String> idsStr);
	/**
	 * 社保士兵医生大增加模板
	 * @Author hgw
	 * @Date 2024-5-10 21:16:41
	 **/
	List<SocialSoldierYsdAddVo> getSocialSoldierYsdAddVoList(@Param("idsStr") List<String> idsStr);
	/**
	 * 社保士兵医生大减少模板
	 * @Author hgw
	 * @Date 2024-5-10 21:16:41
	 **/
	List<SocialSoldierYsdAddVo> getSocialSoldierYsdReduceVoList(@Param("idsStr") List<String> idsStr);

	/**
	 * 社保士兵养工失审核模板
	 * @Author hgw
	 * @Date 2024-5-24 16:39:43
	 **/
	List<SocialSoldierYgsAuditVo> getSocialSoldierYgsAuditVoList();
	/**
	 * 社保士兵医生大审核续保模板
	 * @Author hgw
	 * @Date 2024-5-24 16:39:43
	 **/
	List<SocialSoldierYsdAuditVo> getSocialSoldierYsdAuditVoList();
	/**
	 * 社保士兵养工失审核模板——推送给社保士兵的归总模板
	 * @Author hgw
	 * @Date 2024-9-2 18:03:04
	 **/
	List<SocialSoldierYgsAuditVo> getSocialSoldierYgsAuditVoListByGroupBy();
	/**
	 * 社保士兵医生大审核续保模板——推送给社保士兵的归总模板
	 * @Author hgw
	 * @Date 2024-9-2 18:03:07
	 **/
	List<SocialSoldierYsdAuditVo> getSocialSoldierYsdAuditVoListByGroupBy();
	/**
	 * 社保士兵医生大审核新增模板
	 * @Author hgw
	 * @Date 2024-5-24 16:39:43
	 **/
	List<SocialSoldierYsdAuditVo> getSocialSoldierYsdAddAuditVoList();

	/**
	 * @Description: 工资申报
	 * @Author: hgw
	 * @Date: 2024/5/29 18:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.SocialSoldierSalaryShenBaoVo>
	 **/
	List<SocialSoldierSalaryShenBaoVo> getSoldierSalaryByShenBaoList();
	/**
	 * 社保士兵医生大审核新增模板
	 * @Author hgw
	 * @Date 2024-5-24 16:39:43
	 **/
	List<SocialSoldierYsdAuditVo> getSocialSoldierYsdAddAuditVoListByGroupBy();

	/**
	 * @Description: 工资调整
	 * @Author: hgw
	 * @Date: 2024/5/29 18:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.SocialSoldierSalaryShenBaoVo>
	 **/
	List<SocialSoldierSalaryTiaoZhengVo> getSoldierSalaryByTiaoZhengList();

	/**
	 * @Description: 实缴3张表之日常申报
	 * @Author: hgw
	 * @Date: 2024/5/29 18:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.SocialSoldierSalaryShenBaoVo>
	 **/
	List<SocialSoldierPaymentSelectOneVo> getSoldierPaymentSelectOneList();
	/**
	 * @Description: 实缴3张表之日常申报
	 * @Author: hgw
	 * @Date: 2024/5/29 18:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.SocialSoldierSalaryShenBaoVo>
	 **/
	List<SocialSoldierPaymentSelectTwoVo> getSoldierPaymentSelectTwoList();
	/**
	 * @Description: 实缴3张表之日常申报
	 * @Author: hgw
	 * @Date: 2024/5/29 18:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.SocialSoldierSalaryShenBaoVo>
	 **/
	List<SocialSoldierPaymentSelectThreeVo> getSoldierPaymentSelectThreeList();

	void getSoldierPaymentErrorInfoOne(@Param("paymentTableName") String paymentTableName, @Param("parentId") String parentId);
	void getSoldierPaymentErrorInfoTwo(@Param("paymentTableName") String paymentTableName, @Param("parentId") String parentId);

	void getSoldierPaymentErrorInfoOneByRe(@Param("paymentTableName") String paymentTableName, @Param("parentId") String parentId);
	void getSoldierPaymentErrorInfoTwoByRe(@Param("paymentTableName") String paymentTableName, @Param("parentId") String parentId);

}
