package com.yifu.cloud.plus.v1.business.service.system.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.system.TBusDept;
import com.yifu.cloud.plus.v1.business.mapper.system.TBusDeptMapper;
import com.yifu.cloud.plus.v1.business.service.system.TBusDeptService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * B端部门表
 *
 * @author hgw
 * @date 2021-08-10 10:38:44
 */
@Service("tBusDeptService")
public class TBusDeptServiceImpl extends ServiceImpl<TBusDeptMapper, TBusDept> implements TBusDeptService {

     /**
      * B端部门表简单分页查询
      *
      * @param tBusDept B端部门表
      * @return
      */
     @Override
     public IPage<TBusDept> getTBusDeptPage(Page<TBusDept> page, TBusDept tBusDept) {
          return baseMapper.getTBusDeptPage(page, tBusDept);
     }

     /**
      * B端部门表 全部list
      *
      * @param tBusDept B端部门表
      * @return
      */
     @Override
     public List<TBusDept> getTBusDeptList(TBusDept tBusDept) {
          return baseMapper.getTBusDeptList(tBusDept);
     }

     /**
      * B端部门表 全部list 包括删除
      *
      * @param tBusDept B端部门表
      * @return
      */
     @Override
     public List<TBusDept> getTBusDeptListAsso(TBusDept tBusDept) {
          return baseMapper.getTBusDeptListAsso(tBusDept);
     }

     /**
      * B端部门表 全部list
      *
      * @param tBusDept B端部门表
      * @return
      */
     @Override
     public Map<String, Integer> getTBusDeptMap(TBusDept tBusDept) {
          List<TBusDept> deptList = baseMapper.getTBusDeptList(tBusDept);
          Map<String, Integer> deptMap = new HashMap<>();
          if (deptList != null && !deptList.isEmpty()) {
               for (TBusDept dept : deptList) {
                    deptMap.put(dept.getName(), dept.getId());
               }
          }
          return deptMap;
     }

     /**
      * B端部门表 子集list，不含自己
      * @return
      */
     @Override
     public List<TBusDept> getTBusDeptSubList(int id, String treeLogo) {
          return baseMapper.getTBusDeptSubList(id, treeLogo);
     }

     @Override
     public List<TBusDept> getDeptByName(Integer id, String name) {
          return baseMapper.getDeptByName(id, name);
     }

     @Override
     public int updateAllTreeLogo(String oldLogo, String newLogo) {
          return baseMapper.updateAllTreeLogo(oldLogo, newLogo);
     }

     /**
      * 根据部门父id或等级查询部门列表
      * @param pid 部门pid
      * @param level 部门等级
      * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusDept>>
      * @author: wangweiguo
      * @date: 2021/9/7
      * @since hrob2.1
      */
     @Override
     public R<List<TBusDept>> getBusDepartByLevelOrPid(Integer pid, Integer level) {
          List<TBusDept> list = this.lambdaQuery()
                  .eq(TBusDept::getLevel, level)
                  .eq(pid != null, TBusDept::getPid, pid)
                  .eq(TBusDept::getDeleteFlag, CommonConstants.ZERO_INT)
                  .list();
          return R.ok(list, CommonConstants.SEARCH_SUCCESS);
     }

     /**
      * B端部门表 全部list
      * @return
      */
     @Override
     public Map<String, TBusDept> getAllDeptMap() {
          List<TBusDept> deptList = baseMapper.getTBusDeptList(null);
          Map<String, TBusDept> deptMap = new HashMap<>();
          if (deptList != null && !deptList.isEmpty()) {
               for (TBusDept dept : deptList) {
                    deptMap.put(dept.getName(), dept);
               }
          }
          return deptMap;
     }

}
