package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @Author fxj
 * @Description 保单号列表查询对象
 * @Author fxj
 * @Date 2025/4/7 19:54
 * @Version 1.0
 **/
@Data
@Schema(description = "保单号列表查询对象")
public class InsuranceDetailDispatchVO implements Serializable {
	private static final long serialVersionUID = 628032758008497542L;

	/**
	 * 保单号
	 */
	@Schema(description = "保单号")
	private String policyNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 商险购买地
	 */
	@Schema(description = "商险购买地")
	private String insuranceAreaName;

	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;

}
