package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;


@Data
@TableName("feed_back_detail")
public class FeedBackDetail implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	private String id;

	/**
	 * 反馈人
	 */
	@Schema(description ="反馈人")
	private String feedbackPerson;

	/**
	 * 反馈时间
	 */
	@Schema(description ="反馈时间")
	private Date feedbackTime;

	/**
	 * 反馈原因
	 */
	@Schema(description ="反馈原因")
	private String feedbackReason;

	/**
	 * 反馈详情
	 */
	@Schema(description ="反馈详情")
	private String feedbackDetail;

	/**
	 * 续签代办表关联主键
	 */
	@Schema(description ="续签代办表关联主键")
	private String contractAlertId;

	/**
	 * 续签代办表关联主键
	 */
	@Schema(description ="申请编号")
	private String applyNo;

	@Schema(description ="是否反馈")
	private Integer isFeedback;


	private static final long serialVersionUID = 1L;
}