/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 档案导入导出限制表
 *
 * @author hgw
 * @date 2024-10-24 15:22:51
 */
@Data
@TableName("t_archives_limit")
@Schema(description = "档案导入导出限制表")
public class TArchivesLimit {

	/**
	 * 主键（类型：1预入职导入；2档案更新；3：预入职导出；4档案完整度监控导出，具体的看remark里的说明）
	 */
	@TableId(type = IdType.AUTO)
	@Schema(description = "主键")
	private Integer id;

	@Schema(description = "备注")
	private String remark;

	@Schema(description = "导出最大值（按类型）")
	private Integer maxNum;

}
