/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 档案管理规则配置表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
@TableName("t_auto_emp_rule_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "档案管理规则配置表")
public class TAutoEmpRuleInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 是否启用自动化：0是 1否
	 */
	@ExcelAttribute(name = "是否启用自动化：0是 1否", isNotEmpty = true, errorInfo = "是否启用自动化不能为空", maxLength = 1)
	@NotBlank(message = "是否启用自动化：0是 1否不能为空")
	@Length(max = 1, message = "是否启用自动化：0是 1否不能超过1个字符")
	@ExcelProperty("是否启用自动化：0是 1否")
	@Schema(description = "是否启用自动化：0是 1否")
	private String autoFlag;
	/**
	 * 收集方式：0自动1 手动
	 */
	@ExcelAttribute(name = "收集方式：0自动1 手动")
	@Length(max = 1, message = "收集方式：0自动1 手动不能超过1个字符")
	@ExcelProperty("收集方式：0自动1 手动")
	@Schema(description = "收集方式：0自动1 手动")
	private String collectType;
	/**
	 * 推送类型
	 */
	@ExcelAttribute(name = "推送类型")
	@ExcelProperty("推送类型")
	@Schema(description = "推送类型 0 入职日期")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String pushType;
	/**
	 * 推送时间
	 */
	@ExcelAttribute(name = "推送时间")
	@ExcelProperty("推送时间")
	@Schema(description = "推送时间")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String pushDate;
	/**
	 * 员工类型
	 */
	@ExcelAttribute(name = "员工类型", maxLength = 2)
	@Length(max = 2, message = "员工类型不能超过2个字符")
	@ExcelProperty("员工类型")
	@Schema(description = "员工类型")
	private String empType;
	/**
	 * 档案所在地-省
	 */
	@ExcelAttribute(name = "档案所在地-省", maxLength = 10)
	@Length(max = 10, message = "档案所在地-省不能超过10个字符")
	@ExcelProperty("档案所在地-省")
	@Schema(description = "档案所在地-省")
	private String empProvince;
	/**
	 * 档案所在地-市
	 */
	@ExcelAttribute(name = "档案所在地-市", maxLength = 10)
	@Length(max = 10, message = "档案所在地-市不能超过10个字符")
	@ExcelProperty("档案所在地-市")
	@Schema(description = "档案所在地-市")
	private String empCity;
	/**
	 * 档案所在地-县/区
	 */
	@ExcelAttribute(name = "档案所在地-县/区", maxLength = 10)
	@Length(max = 10, message = "档案所在地-县/区不能超过10个字符")
	@ExcelProperty("档案所在地-县/区")
	@Schema(description = "档案所在地-县/区")
	private String empTown;
	/**
	 * 合同类型
	 */
	@ExcelAttribute(name = "合同类型", maxLength = 10)
	@Length(max = 10, message = "合同类型不能超过10个字符")
	@ExcelProperty("合同类型")
	@Schema(description = "合同类型")
	private String contractType;
	/**
	 * 业务细分（同合的业务细分）
	 */
	@ExcelAttribute(name = "业务细分（同合的业务细分）")
	@NotBlank(message = "业务细分（同合的业务细分）不能为空")
	@Length(max = 32, message = "业务细分（同合的业务细分）不能超过32个字符")
	@ExcelProperty("业务细分（同合的业务细分）")
	@Schema(description = "业务细分（同合的业务细分）")
	private String businessTypeSub;
	/**
	 * 默认信息是否允许修改
	 */
	@ExcelAttribute(name = "默认信息是否允许修改", isNotEmpty = true, errorInfo = "默认信息是否允许修改不能为空", maxLength = 1)
	@NotBlank(message = "默认信息是否允许修改不能为空")
	@Length(max = 1, message = "默认信息是否允许修改不能超过1个字符")
	@ExcelProperty("默认信息是否允许修改")
	@Schema(description = "默认信息是否允许修改")
	private String updateFlag;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码")
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@ExcelAttribute(name = "项目ID")
	@Length(max = 32, message = "项目ID不能超过32个字符")
	@ExcelProperty("项目ID")
	@Schema(description = "项目ID")
	private String deptId;
	/**
	 * 项目配置主表ID
	 */
	@ExcelAttribute(name = "项目配置主表ID")
	@Length(max = 32, message = "项目配置主表ID不能超过32个字符")
	@ExcelProperty("项目配置主表ID")
	@Schema(description = "项目配置主表ID")
	private String mainId;

}
