package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMax;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 部门结算信息表
 *
 * @author wangan
 * @date 2019-08-09 12:24:14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_depart_settlement_info")
@Schema(description = "部门结算信息表")
public class TDepartSettlementInfo extends Model<TDepartSettlementInfo> {
	private static final long serialVersionUID = 1L;
	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键", name = "id")
	private String id;
	/**
	 * 社保卡收取  单位  个人
	 */
	@Length(max = 1, message = "社保卡收取不能超过1个字符")
	@ExcelAttribute(name = "社保卡收取", maxLength = 1)
	@Schema(description = "社保卡收取", name = "socialCardTaker")
	private String socialCardTaker;
	/**
	 * 岗位
	 */
	@Length(max = 32, message = "岗位不能超过32个字符")
	@ExcelAttribute(name = "岗位", maxLength = 32)
	@Schema(description = "岗位", name = "station")
	private String station;
	/**
	 * 管理费是否收费（0收费/1不收费）
	 */
	@Length(max = 1, message = "管理费是否收费（0收费/1不收费）不能超过1个字符")
	@ExcelAttribute(name = "管理费是否收费（0收费/1不收费）", maxLength = 1)
	@Schema(description = "管理费是否收费（0收费/1不收费）", name = "managementTag")
	private String managementTag;
	/**
	 * 管理费收取项目    如：应发工资   单位社保   单位公积金   商险   单位社保卡费   单位代扣   其他费用1   其他费用2   其他费用3
	 */
	@Length(max = 255, message = "管理费收取项目不能超过255个字符")
	@ExcelAttribute(name = "管理费收取项目")
	@Schema(description = "管理费收取项目", name = "managementTag")
	private String manageServerItem;
	/**
	 * 风险金收取项目
	 */
	@Length(max = 255, message = "风险金收取项目不能超过255个字符")
	@ExcelAttribute(name = "风险金收取项目")
	@Schema(description = "风险金收取项目", name = "riskServerItem")
	private String riskServerItem;
	/**
	 * 管理费费率/管理费金额
	 */
	@DecimalMax(value = "999999.999", message = "管理费费率（管理费金额）不能大于999999.999")
	@ExcelAttribute(name = "管理费费率/管理费金额")
	@Schema(description = "管理费费率/管理费金额", name = "managementFee")
	private BigDecimal managementFee;
	/**
	 * 管理费收费类型  按固定值 按比例
	 */
	@Length(max = 32, message = "管理费收费类型不能超过32个字符")
	@ExcelAttribute(name = "管理费收费类型", maxLength = 32)
	@Schema(description = "管理费收费类型(0：固定；1：比例)", name = "managementType")
	private String managementType;

	/**
	 * 风险金是否收取
	 */
	@Length(max = 1, message = "风险金是否收取不能超过1个字符")
	@ExcelAttribute(name = "风险金是否收取", maxLength = 1)
	@Schema(description = "风险金是否收取（0收费/1不收费）", name = "riskFundTag")
	private String riskFundTag;
	/**
	 * 风险金收取费用/税率
	 */
	@DecimalMax(value = "9999999.99", message = "风险金收取费用/税率不能大于9999999.99")
	@ExcelAttribute(name = "风险金收取费用/税率")
	@Schema(description = "风险金收取费用/税率", name = "riskFundFee")
	private BigDecimal riskFundFee;
	/**
	 * 风险金收取方式
	 */
	@Length(max = 32, message = "风险金收取方式不能超过32个字符")
	@ExcelAttribute(name = "风险金收取方式", maxLength = 32)
	@Schema(description = "风险金收取方式(0：固定；1：比例)", name = "riskFundType")
	private String riskFundType;
	/**
	 * 缴税类型（交税类型）  增值税-专票 增值税-普票 差额纳税-专票  差额纳税-普票
	 */
	@Length(max = 32, message = "缴税类型不能超过32个字符")
	@ExcelAttribute(name = "缴税类型", maxLength = 32)
	@Schema(description = "缴税类型", name = "taxType")
	private String taxType;
	/**
	 * 风险金税收类型
	 */
	@Length(max = 1, message = "风险金税收类型不能超过1个字符")
	@ExcelAttribute(name = "风险金税收类型", maxLength = 1)
	@Schema(description = "风险金税收类型（0:税前;1:税后(需要计算)）", name = "riskFundTaxTag")
	private String riskFundTaxTag;
	/**
	 * 管理费税收类型  1含税 0不含税
	 */
	@Length(max = 1, message = "管理费税收类型不能超过1个字符")
	@ExcelAttribute(name = "管理费税收类型", maxLength = 1)
	@Schema(description = "管理费税收类型（0:税前;1:税后(需要计算)）", name = "managementTaxTag")
	private String managementTaxTag;
	/**
	 * 单位大病比例
	 */
	@ExcelAttribute(name = "单位大病比例")
	@DecimalMax(value = "100.00", message = "单位大病比例不能大于100.00")
	@Schema(description = "单位大病比例", name = "unitSeriousIllnessProp")
	private BigDecimal unitSeriousIllnessProp;
	/**
	 * 创建人
	 */
	@Length(max = 32, message = "创建人不能超过32个字符")
	@ExcelAttribute(name = "创建人", maxLength = 32)
	@Schema(description = "创建人", name = "createUser")
	private String createUser;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间")
	@Schema(description = "创建时间", name = "createTime")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	private LocalDateTime createTime;
	/**
	 * 最后更新人
	 */
	@Length(max = 32, message = "最后更新人不能超过32个字符")
	@ExcelAttribute(name = "最后更新人", maxLength = 32)
	@Schema(description = "最后更新人", name = "lastUpdateUser")
	private String lastUpdateUser;
	/**
	 * 最后更新时间
	 */
	@ExcelAttribute(name = "最后更新时间")
	@Schema(description = "最后更新时间", name = "lastUpdateTime")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	private LocalDateTime lastUpdateTime;
	/**
	 * 结算主体ID
	 */
	@Length(max = 32, message = "结算主体ID不能超过32个字符")
	@ExcelAttribute(name = "结算主体ID", maxLength = 32)
	@Schema(description = "结算主体ID", name = "settleId")
	private String settleId;
	/**
	 * 缴税税率
	 */
	@DecimalMax(value = "99.99", message = "缴税税率不能大于99.99")
	@ExcelAttribute(name = "缴税税率")
	@Schema(description = "缴税税率", name = "taxFee")
	private BigDecimal taxFee;
	/**
	 * 管理费是否扣税
	 * 0是/1否
	 *
	 * @Author pwang
	 * @Date 2020-04-26 9:38
	 * @param null
	 * @return
	 **/
	@Length(max = 1, message = "管理费是否扣税字段不能超过1个字符")
	@Schema(description = "管理费是否扣税")
	private String managementExpFlag;

}
