/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 员工工作履历信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Data
@TableName("t_emp_work_recording")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工工作履历信息表")
public class TEmpWorkRecording extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 员工ID
     */
    @Schema(description ="员工ID")
    private String empId;

    /**
     * 员工编码
     */
    @Schema(description ="员工编码")
    private String empCode;

    /**
     * 员工姓名
     */
    @Schema(description ="员工姓名")
    private String empName;

    /**
     * 身份证号
     */
    @Schema(description ="身份证号")
    private String empIdcard;

    /**
     * 工作单位
     */
    @Schema(description ="工作单位")
    private String workUnit;

    /**
     * 工作部门
     */
    @Schema(description ="工作部门")
    private String workDepart;

    /**
     * 工作岗位
     */
    @Schema(description ="工作岗位")
    private String workJob;

    /**
     * 开始工作日期
     */
    @Schema(description ="开始工作日期")
    private LocalDateTime startDate;

    /**
     * 结束工作日期
     */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
    @Schema(description ="结束工作日期")
    private LocalDateTime endDate;

    /**
     * 在职状态0是/1否
     */
    @Schema(description ="在职状态0是/1否")
    private String workingStatus;

    /**
     * 人员类型
     */
    @Schema(description ="人员类型")
    private String workingType;

	/**
	 * 项目ID
	 */
	@Schema(description ="项目ID")
	private String  settleDomain;

    /**
     * 0删除作废1正常
     */
	@TableLogic
    @Schema(description ="0删除作废1正常")
    private String deleteFlag;
	/**
	 * 备注
	 */
	@Schema(description ="备注")
	private String remark;

}
