/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 法大大编辑日志表
 *
 * @author hgw
 * @date 2025-10-09 10:39:43
 */
@Data
@TableName("t_fasc_edit_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大编辑日志表")
public class TFascEditLog extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 关联主表ID
	 */
	@ExcelAttribute(name = "关联主表ID", isNotEmpty = true, errorInfo = "关联主表ID不能为空", maxLength = 32)
	@NotBlank(message = "关联主表ID不能为空")
	@Length(max = 32, message = "关联主表ID不能超过32个字符")
	@ExcelProperty("关联主表ID")
	@Schema(description = "关联主表ID")
	private String mainId;
	/**
	 * 类型1模板2映射
	 */
	@ExcelAttribute(name = "类型1模板2映射", isNotEmpty = true, errorInfo = "类型1模板2映射不能为空", maxLength = 1)
	@NotBlank(message = "类型1模板2映射不能为空")
	@Length(max = 1, message = "类型1模板2映射不能超过1个字符")
	@ExcelProperty("类型1模板2映射")
	@Schema(description = "类型1模板2映射")
	private String mainType;
	/**
	 * 编辑内容
	 */
	@ExcelAttribute(name = "编辑内容", isNotEmpty = true, errorInfo = "编辑内容不能为空", maxLength = 100)
	@NotBlank(message = "编辑内容不能为空")
	@Length(max = 100, message = "编辑内容不能超过100个字符")
	@ExcelProperty("编辑内容")
	@Schema(description = "编辑内容")
	private String editContent;

}
