/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 法大大专业版皖信字段表
 *
 * @author hgw
 * @date 2025-09-30 16:29:27
 */
@Data
@TableName("t_fasc_hr_field")
@Schema(description = "法大大专业版皖信字段表")
public class TFascHrField {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 皖信字段
	 */
	@ExcelAttribute(name = "皖信字段", maxLength = 100)
	@Length(max = 100, message = "皖信字段不能超过100个字符")
	@ExcelProperty("皖信字段")
	@Schema(description = "皖信字段")
	private String hrField;
	/**
	 * 皖信字段ID
	 */
	@ExcelAttribute(name = "皖信字段ID", maxLength = 100)
	@Length(max = 100, message = "皖信字段ID不能超过100个字符")
	@ExcelProperty("皖信字段ID")
	@Schema(description = "皖信字段ID")
	private String hrFieldId;
	/**
	 * 合同类型：标准合同、劳务协议、实习协议、非全日制、劳务派遣合同
	 */
	@ExcelAttribute(name = "合同类型", maxLength = 20)
	@Length(max = 20, message = "合同类型不能超过20个字符")
	@ExcelProperty("合同类型")
	@Schema(description = "合同类型")
	private String contractType;

}
