/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 瓜子档案表
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Data
@TableName("t_gz_emp_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子档案表")
public class TGzEmpInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;

	/**
	 * 关联瓜子offerID
	 */
	@ExcelProperty("关联瓜子offerID")
	@Schema(description = "关联瓜子offerID")
	private Integer offerId;

	@Schema(description = "流程ID（瓜子推过来的主键）")
	private String bizId;

	/**
	 * 档案推送状态（0：待推送；1：已推送）
	 */
	@ExcelAttribute(name = "档案推送状态（0：待推送；1：已推送）", maxLength = 1)
	@Length(max = 1, message = "档案推送状态（0：待推送；1：已推送）不能超过1个字符")
	@ExcelProperty("档案推送状态（0：待推送；1：已推送）")
	@Schema(description = "档案推送状态（0：待推送；1：已推送）")
	private String empPushStatus;
	/**
	 * 合同信息推送状态（0：待推送；1：已推送）
	 */
	@ExcelAttribute(name = "合同信息推送状态（0：待推送；1：已推送）", maxLength = 1)
	@Length(max = 1, message = "合同信息推送状态（0：待推送；1：已推送）不能超过1个字符")
	@ExcelProperty("合同信息推送状态（0：待推送；1：已推送）")
	@Schema(description = "合同信息推送状态（0：待推送；1：已推送）")
	private String contractPushStatus;
	/**
	 * 合同附件推送状态（0：待推送；1：已推送）
	 */
	@ExcelAttribute(name = "合同附件推送状态（0：待推送；1：已推送）", maxLength = 1)
	@Length(max = 1, message = "合同附件推送状态（0：待推送；1：已推送）不能超过1个字符")
	@ExcelProperty("合同附件推送状态（0：待推送；1：已推送）")
	@Schema(description = "合同附件推送状态（0：待推送；1：已推送）")
	private String contractAttaPushStatus;
	/**
	 * 删除标记
	 */
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@ExcelProperty("删除标记")
	@Schema(description = "删除标记")
	@TableLogic
	private String delFlag;

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String name;
	/**
	 * 姓名拼音
	 */
	@ExcelAttribute(name = "姓名拼音", maxLength = 100)
	@Length(max = 100, message = "姓名拼音不能超过100个字符")
	@ExcelProperty("姓名拼音")
	@Schema(description = "姓名拼音")
	private String nameAc;
	/**
	 * 出生日期
	 */
	@ExcelAttribute(name = "出生日期", isDate = true)
	@ExcelProperty("出生日期")
	@Schema(description = "出生日期")
	private Date birthdate;
	/**
	 * 性别
	 */
	@ExcelAttribute(name = "性别", maxLength = 2)
	@Length(max = 2, message = "性别不能超过2个字符")
	@ExcelProperty("性别")
	@Schema(description = "性别")
	private String sex;
	/**
	 * 星座
	 */
	@ExcelAttribute(name = "星座", maxLength = 10)
	@Length(max = 10, message = "星座不能超过10个字符")
	@ExcelProperty("星座")
	@Schema(description = "星座")
	private String constel;
	/**
	 * 血型
	 */
	@ExcelAttribute(name = "血型", maxLength = 2)
	@Length(max = 2, message = "血型不能超过2个字符")
	@ExcelProperty("血型")
	@Schema(description = "血型")
	private String bloodType;
	/**
	 * 首次工作日期
	 */
	@ExcelAttribute(name = "首次工作日期", isDate = true)
	@ExcelProperty("首次工作日期")
	@Schema(description = "首次工作日期")
	private Date startDate;
	/**
	 * 国籍
	 */
	@ExcelAttribute(name = "国籍", maxLength = 2)
	@Length(max = 2, message = "国籍不能超过2个字符")
	@ExcelProperty("国籍")
	@Schema(description = "国籍")
	private String country;
	/**
	 * 籍贯
	 */
	@ExcelAttribute(name = "籍贯", maxLength = 12)
	@Length(max = 12, message = "籍贯不能超过12个字符")
	@ExcelProperty("籍贯")
	@Schema(description = "籍贯")
	private String nativePlace;

	@Schema(description = "籍贯地区ID")
	private Integer nativePlaceAreaId;

	/**
	 * 民族
	 */
	@ExcelAttribute(name = "民族", maxLength = 10)
	@Length(max = 10, message = "民族不能超过10个字符")
	@ExcelProperty("民族")
	@Schema(description = "民族")
	private String ethnicGrpCd;
	/**
	 * 婚姻状态
	 */
	@ExcelAttribute(name = "婚姻状态", maxLength = 1)
	@Length(max = 3, message = "婚姻状态不能超过1个字符")
	@ExcelProperty("婚姻状态")
	@Schema(description = "婚姻状态")
	private String marStatus;
	/**
	 * 政治面貌
	 */
	@ExcelAttribute(name = "政治面貌", maxLength = 3)
	@Length(max = 3, message = "政治面貌不能超过3个字符")
	@ExcelProperty("政治面貌")
	@Schema(description = "政治面貌")
	private String politicalSta;
	/**
	 * 是否新参社保(Y:是 N:否)
	 */
	@ExcelAttribute(name = "是否新参社保", maxLength = 3)
	@Length(max = 3, message = "是否新参社保不能超过3个字符")
	@ExcelProperty("是否新参社保")
	@Schema(description = "是否新参社保")
	private String insuranceSta;
	/**
	 * 驾照类型
	 */
	@ExcelAttribute(name = "驾照类型", maxLength = 2)
	@Length(max = 2, message = "驾照类型不能超过2个字符")
	@ExcelProperty("驾照类型")
	@Schema(description = "驾照类型")
	private String driverType;
	/**
	 * 驾照到期日
	 * // “驾照失效日期”改成“驾照到期日”
	 */
	@ExcelAttribute(name = "驾照到期日", isDate = true)
	@ExcelProperty("驾照到期日")
	@Schema(description = "驾照到期日")
	private Date driverLicenExp;
	/**
	 * 证件类型
	 */
	@ExcelAttribute(name = "证件类型", maxLength = 2)
	@Length(max = 2, message = "证件类型不能超过2个字符")
	@ExcelProperty("证件类型")
	@Schema(description = "证件类型")
	private String nationalIdType;
	/**
	 * 证件号码
	 */
	@ExcelAttribute(name = "证件号码", maxLength = 32)
	@Length(max = 32, message = "证件号码不能超过32个字符")
	@ExcelProperty("证件号码")
	@Schema(description = "证件号码")
	private String nationalId;
	/**
	 * 是否永久有效(Y:是 N:否)
	 */
	@ExcelAttribute(name = "是否永久有效(Y:是 N:否)", maxLength = 2)
	@Length(max = 2, message = "是否永久有效(Y:是 N:否)不能超过2个字符")
	@ExcelProperty("是否永久有效(Y:是 N:否)")
	@Schema(description = "是否永久有效(Y:是 N:否)")
	private String persistFlag;
	/**
	 * 证件有效期开始日期
	 */
	@ExcelAttribute(name = "证件有效期开始日期", isDate = true)
	@ExcelProperty("证件有效期开始日期")
	@Schema(description = "证件有效期开始日期")
	private Date nidStartDate;
	/**
	 * 证件有效期结束日期
	 */
	@ExcelAttribute(name = "证件有效期结束日期", isDate = true)
	@ExcelProperty("证件有效期结束日期")
	@Schema(description = "证件有效期结束日期")
	private Date nidExpiryDate;
	/**
	 * 移动电话
	 */
	@ExcelAttribute(name = "移动电话", maxLength = 11)
	@Length(max = 11, message = "移动电话不能超过11个字符")
	@ExcelProperty("移动电话")
	@Schema(description = "移动电话")
	private String phone;
	/**
	 * 个人邮箱
	 */
	@ExcelAttribute(name = "个人邮箱", maxLength = 50)
	@Length(max = 50, message = "个人邮箱不能超过50个字符")
	@ExcelProperty("个人邮箱")
	@Schema(description = "个人邮箱")
	private String mail;
	/**
	 * 地址类型
	 */
	@ExcelAttribute(name = "地址类型", maxLength = 8)
	@Length(max = 8, message = "地址类型不能超过8个字符")
	@ExcelProperty("地址类型")
	@Schema(description = "地址类型")
	private String addressType;
	/**
	 * 家庭住址-所在省编码
	 */
	@ExcelAttribute(name = "家庭住址-所在省编码", maxLength = 12)
	@Length(max = 12, message = "家庭住址-所在省编码不能超过12个字符")
	@ExcelProperty("家庭住址-所在省编码")
	@Schema(description = "家庭住址-所在省编码")
	private String stateId;
	/**
	 * 家庭住址-所在市编码
	 */
	@ExcelAttribute(name = "家庭住址-所在市编码", maxLength = 12)
	@Length(max = 12, message = "家庭住址-所在市编码不能超过12个字符")
	@ExcelProperty("家庭住址-所在市编码")
	@Schema(description = "家庭住址-所在市编码")
	private String cityId;
	/**
	 * 家庭住址-所在区编码
	 */
	@ExcelAttribute(name = "家庭住址-所在区编码", maxLength = 12)
	@Length(max = 12, message = "家庭住址-所在区编码不能超过12个字符")
	@ExcelProperty("家庭住址-所在区编码")
	@Schema(description = "家庭住址-所在区编码")
	private String countyId;

	@Schema(description = "家庭住址-所在省地区ID")
	private Integer stateAreaId;

	@Schema(description = "家庭住址-所在市地区ID")
	private Integer cityAreaId;

	@Schema(description = "家庭住址-所在区地区ID")
	private Integer countyAreaId;
	/**
	 * 家庭住址-详细地址
	 */
	@ExcelAttribute(name = "家庭住址-详细地址", maxLength = 200)
	@Length(max = 200, message = "家庭住址-详细地址不能超过200个字符")
	@ExcelProperty("家庭住址-详细地址")
	@Schema(description = "家庭住址-详细地址")
	private String address;
	/**
	 * 合同签署方式
	 */
	@ExcelAttribute(name = "合同签署方式", maxLength = 3)
	@Length(max = 3, message = "合同签署方式不能超过3个字符")
	@ExcelProperty("合同签署方式")
	@Schema(description = "合同签署方式")
	private String sginatureMethod;
	/**
	 * 合同编号
	 */
	@ExcelAttribute(name = "合同编号", maxLength = 32)
	@Length(max = 32, message = "合同编号不能超过32个字符")
	@ExcelProperty("合同编号")
	@Schema(description = "合同编号")
	private String contractNum;
	/**
	 * 合同类型
	 */
	@ExcelAttribute(name = "合同类型", maxLength = 2)
	@Length(max = 2, message = "合同类型不能超过2个字符")
	@ExcelProperty("合同类型")
	@Schema(description = "合同类型")
	private String contractType;
	/**
	 * 合同签订类型
	 */
	@ExcelAttribute(name = "合同签订类型", maxLength = 1)
	@Length(max = 1, message = "合同签订类型不能超过1个字符")
	@ExcelProperty("合同签订类型")
	@Schema(description = "合同签订类型")
	private String sginatureType;
	/**
	 * 试用期
	 */
	@ExcelAttribute(name = "试用期", maxLength = 2)
	@Length(max = 2, message = "试用期不能超过2个字符")
	@ExcelProperty("试用期")
	@Schema(description = "试用期")
	private String probation;
	/**
	 * 合同签订日期
	 */
	@ExcelAttribute(name = "合同签订日期", isDate = true)
	@ExcelProperty("合同签订日期")
	@Schema(description = "合同签订日期")
	private Date sginatureDt;
	/**
	 * 合同开始日期
	 */
	@ExcelAttribute(name = "合同开始日期", isDate = true)
	@ExcelProperty("合同开始日期")
	@Schema(description = "合同开始日期")
	private Date contractBeginDt;
	/**
	 * 合同预计结束日期
	 */
	@ExcelAttribute(name = "合同预计结束日期", isDate = true)
	@ExcelProperty("合同预计结束日期")
	@Schema(description = "合同预计结束日期")
	private Date contractExpEndDt;
	/**
	 * 合同结束日期
	 */
	@ExcelAttribute(name = "合同结束日期", isDate = true)
	@ExcelProperty("合同结束日期")
	@Schema(description = "合同结束日期")
	private Date contractEndDt;
	/**
	 * 预计转正日期
	 */
	@ExcelAttribute(name = "预计转正日期", isDate = true)
	@ExcelProperty("预计转正日期")
	@Schema(description = "预计转正日期")
	private Date probationDt;
	/**
	 * 试用期预计结束日期
	 */
	@ExcelAttribute(name = "试用期预计结束日期", isDate = true)
	@ExcelProperty("试用期预计结束日期")
	@Schema(description = "试用期预计结束日期")
	private Date prcExpDt;
	/**
	 * 合同签署主体(系统固定传 V59)
	 */
	@ExcelAttribute(name = "合同签署主体", maxLength = 30)
	@Length(max = 30, message = "合同签署主体不能超过30个字符")
	@ExcelProperty("合同签署主体")
	@Schema(description = "合同签署主体")
	private String neeProviderId;
	/**
	 * 合同工作地
	 */
	@ExcelAttribute(name = "合同工作地", maxLength = 200)
	@Length(max = 200, message = "合同工作地不能超过200个字符")
	@ExcelProperty("合同工作地")
	@Schema(description = "合同工作地")
	private String workLocation;

	/**
	 * 合同工作地描述
	 */
	@ExcelAttribute(name = "合同工作地描述", maxLength = 200)
	@Length(max = 200, message = "合同工作地描述不能超过200个字符")
	@ExcelProperty("合同工作地描述")
	@Schema(description = "合同工作地描述")
	private String workLocationDescr;
	/**
	 * 状态
	 */
	@ExcelAttribute(name = "状态", maxLength = 2)
	@Length(max = 2, message = "状态不能超过2个字符")
	@ExcelProperty("状态")
	@Schema(description = "状态")
	private String contractState;
	/**
	 * 户口类型
	 */
	@ExcelAttribute(name = "户口类型", maxLength = 10)
	@Length(max = 10, message = "户口类型不能超过10个字符")
	@ExcelProperty("户口类型")
	@Schema(description = "户口类型")
	private String hukouType;
	/**
	 * 户口-所在省编码
	 */
	@ExcelAttribute(name = "户口-所在省编码", maxLength = 12)
	@Length(max = 12, message = "户口-所在省编码不能超过12个字符")
	@ExcelProperty("户口-所在省编码")
	@Schema(description = "户口-所在省编码")
	private String hukouProvince;
	/**
	 * 户口-所在市编码
	 */
	@ExcelAttribute(name = "户口-所在市编码", maxLength = 12)
	@Length(max = 12, message = "户口-所在市编码不能超过12个字符")
	@ExcelProperty("户口-所在市编码")
	@Schema(description = "户口-所在市编码")
	private String hukouCity;
	/**
	 * 户口-所在区编码
	 */
	@ExcelAttribute(name = "户口-所在区编码", maxLength = 12)
	@Length(max = 12, message = "户口-所在区编码不能超过12个字符")
	@ExcelProperty("户口-所在区编码")
	@Schema(description = "户口-所在区编码")
	private String hukouCounty;

	@Schema(description = "户口-所在省地区ID")
	private Integer hukouProvinceAreaId;

	@Schema(description = "户口-所在市地区ID")
	private Integer hukouCityAreaId;

	@Schema(description = "户口-所在区地区ID")
	private Integer hukouCountyAreaId;

	/**
	 * 户口地址
	 */
	@ExcelAttribute(name = "户口地址", maxLength = 100)
	@Length(max = 100, message = "户口地址不能超过100个字符")
	@ExcelProperty("户口地址")
	@Schema(description = "户口地址")
	private String hukouDetail;
	/**
	 * 银行账户类型
	 */
	@ExcelAttribute(name = "银行账户类型", maxLength = 2)
	@Length(max = 2, message = "银行账户类型不能超过2个字符")
	@ExcelProperty("银行账户类型")
	@Schema(description = "银行账户类型")
	private String accountType;
	/**
	 * 银行账户状态
	 */
	@ExcelAttribute(name = "银行账户状态", maxLength = 5)
	@Length(max = 5, message = "银行账户状态不能超过5个字符")
	@ExcelProperty("银行账户状态")
	@Schema(description = "银行账户状态")
	private String accountStatus;
	/**
	 * 银行账户国家/地区
	 */
	@ExcelAttribute(name = "银行账户国家/地区", maxLength = 100)
	@Length(max = 100, message = "银行账户国家/地区不能超过100个字符")
	@ExcelProperty("银行账户国家/地区")
	@Schema(description = "银行账户国家/地区")
	private String accountCountry;
	/**
	 * 开户行银行编码
	 */
	@ExcelAttribute(name = "开户行银行编码", maxLength = 100)
	@Length(max = 100, message = "开户行银行编码不能超过100个字符")
	@ExcelProperty("开户行银行编码")
	@Schema(description = "开户行银行编码")
	private String bankCd;
	/**
	 * 联行号ID
	 */
	@ExcelAttribute(name = "联行号ID", maxLength = 100)
	@Length(max = 100, message = "联行号ID不能超过100个字符")
	@ExcelProperty("联行号ID")
	@Schema(description = "联行号ID")
	private String cnapsId;
	/**
	 * 开户行名称
	 */
	@ExcelAttribute(name = "开户行名称", maxLength = 100)
	@Length(max = 100, message = "开户行名称不能超过100个字符")
	@ExcelProperty("开户行名称")
	@Schema(description = "开户行名称")
	private String bankName;
	/**
	 * 开户行所在省
	 */
	@ExcelAttribute(name = "开户行所在省", maxLength = 100)
	@Length(max = 100, message = "开户行所在省不能超过100个字符")
	@ExcelProperty("开户行所在省")
	@Schema(description = "开户行所在省")
	private String accountProvince;
	/**
	 * 开户行所在市
	 */
	@ExcelAttribute(name = "开户行所在市", maxLength = 100)
	@Length(max = 100, message = "开户行所在市不能超过100个字符")
	@ExcelProperty("开户行所在市")
	@Schema(description = "开户行所在市")
	private String accountCity;

	@Schema(description = "开户行所在省地区ID")
	private Integer accountProvinceAreaId;

	@Schema(description = "开户行所在市地区ID")
	private Integer accountCityAreaId;

	/**
	 * 账号ID
	 */
	@ExcelAttribute(name = "账号ID", maxLength = 100)
	@Length(max = 100, message = "账号ID不能超过100个字符")
	@ExcelProperty("账号ID")
	@Schema(description = "账号ID")
	private String accountEcId;
	/**
	 * 持卡人姓名
	 */
	@ExcelAttribute(name = "持卡人姓名", maxLength = 100)
	@Length(max = 100, message = "持卡人姓名不能超过100个字符")
	@ExcelProperty("持卡人姓名")
	@Schema(description = "持卡人姓名")
	private String accountName;

	@Schema(description = "档案状态（0：已提交，1：暂存）")
	private String empStatus;

	@Schema(description = "档案提交时间")
	private LocalDateTime submitTime;

}
