/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;
import java.util.Date;
import javax.validation.constraints.NotBlank;

/**
 * 瓜子技能证书
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Data
@TableName("t_gz_emp_skill")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子技能证书")
public class TGzEmpSkill extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 关联瓜子档案ID
	 */
	@ExcelAttribute(name = "关联瓜子档案ID", isNotEmpty = true, errorInfo = "关联瓜子档案ID不能为空", maxLength = 32)
	@NotBlank(message = "关联瓜子档案ID不能为空")
	@Length(max = 32, message = "关联瓜子档案ID不能超过32个字符")
	@ExcelProperty("关联瓜子档案ID")
	@Schema(description = "关联瓜子档案ID")
	private String empId;
	/**
	 * 删除标记
	 */
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@ExcelProperty("删除标记")
	@Schema(description = "删除标记")
	@TableLogic
	private String delFlag;

	/**
	 * 专业技能名称
	 */
	@ExcelAttribute(name = "专业技能名称", maxLength = 30)
	@Length(max = 30, message = "专业技能名称不能超过30个字符")
	@ExcelProperty("专业技能名称")
	@Schema(description = "专业技能名称")
	private String skillName;
	/**
	 * 获得日期
	 */
	@ExcelAttribute(name = "获得日期", isDate = true)
	@ExcelProperty("获得日期")
	@Schema(description = "获得日期")
	private Date skillDate;
	/**
	 * 授予单位
	 */
	@ExcelAttribute(name = "授予单位", maxLength = 30)
	@Length(max = 30, message = "授予单位不能超过30个字符")
	@ExcelProperty("授予单位")
	@Schema(description = "授予单位")
	private String skillOrg;
	/**
	 * 技术等级
	 */
	@ExcelAttribute(name = "技术等级", maxLength = 30)
	@Length(max = 30, message = "技术等级不能超过30个字符")
	@ExcelProperty("技术等级")
	@Schema(description = "技术等级")
	private String skillLevel;

}
