/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 瓜子offer信息接收表
 *
 * @author chenyx
 * @date 2025-06-11 15:58:37
 */
@Data
@TableName("t_gz_offer_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子offer信息接收表")
public class TGzOfferInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.AUTO)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private Integer id;

	/**
	 * 流程ID（瓜子推过来的主键）
	 */
	@ExcelAttribute(name = "流程ID（瓜子推过来的主键）", isNotEmpty = true, errorInfo = "流程ID（瓜子推过来的主键）不能为空", maxLength = 32)
	@NotBlank(message = "流程ID（瓜子推过来的主键）不能为空")
	@Length(max = 32, message = "流程ID（瓜子推过来的主键）不能超过32个字符")
	@ExcelProperty("流程ID（瓜子推过来的主键）")
	@Schema(description = "流程ID（瓜子推过来的主键）")
	private String bizId;

	/**
	 * Offer状态
	 * （3：待发送Offer，4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，
	 * 12：候选人信息审核，13：待签署，8：合同审核通过，99：已归档，98：信息待收集，97：候选人审核通过）
	 */
	@ExcelAttribute(name = "Offer状态（3：待发送Offer，4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，13：待签署，8：合同审核通过。99：已归档）", isNotEmpty = true, errorInfo = "Offer状态（3：待发送Offer，4：待接受Offer，5：拒绝Offer，7：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，13：待签署，8：合同审核通过。99：已归档）不能为空", maxLength = 2)
	@NotBlank(message = "Offer状态（3：待发送Offer，4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，13：待签署，8：合同审核通过。99：已归档）不能为空")
	@Length(max = 2, message = "Offer状态（3：待发送Offer，4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，13：待签署，8：合同审核通过。99：已归档）不能超过2个字符")
	@ExcelProperty("Offer状态（3：待发送Offer，4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，13：待签署，8：合同审核通过。99：已归档）")
	@Schema(description = "Offer状态（3：待发送Offer，4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，13：待签署，8：合同审核通过。99：已归档）")
	private String offerStatus;
	/**
	 * Offer短信通知状态( 0：已发送；1：未发送)
	 */
	@ExcelAttribute(name = "Offer短信通知状态( 0：已发送；1：未发送)", maxLength = 1)
	@Length(max = 1, message = "Offer短信通知状态( 0：已发送；1：未发送)不能超过1个字符")
	@ExcelProperty("Offer短信通知状态( 0：已发送；1：未发送)")
	@Schema(description = "Offer短信通知状态( 0：已发送；1：未发送)")
	private String offerSendStatus;

	/**
	 * 人员类别编码：参考字典
	 */
	@ExcelAttribute(name = "人员类别编码：参考字典", maxLength = 2)
	@Length(max = 2, message = "人员类别编码：参考字典不能超过2个字符")
	@ExcelProperty("人员类别编码：参考字典")
	@Schema(description = "人员类别编码：参考字典")
	private String emplType;
	/**
	 * 人员类别名称
	 */
	@ExcelAttribute(name = "人员类别名称", maxLength = 32)
	@Length(max = 32, message = "人员类别名称不能超过32个字符")
	@ExcelProperty("人员类别名称")
	@Schema(description = "人员类别名称")
	private String emplTypeDescr;
	/**
	 * 外签类型：A： 洼地外签/ B：属地外签
	 */
	@ExcelAttribute(name = "外签类型：A： 洼地外签/ B：属地外签", maxLength = 2)
	@Length(max = 2, message = "外签类型：A： 洼地外签/ B：属地外签不能超过2个字符")
	@ExcelProperty("外签类型：A： 洼地外签/ B：属地外签")
	@Schema(description = "外签类型：A： 洼地外签/ B：属地外签")
	private String outSginType;
	/**
	 * 合同公司主体：公司信息表
	 */
	@ExcelAttribute(name = "合同公司主体：公司信息表", maxLength = 20)
	@Length(max = 20, message = "合同公司主体：公司信息表不能超过20个字符")
	@ExcelProperty("合同公司主体：公司信息表")
	@Schema(description = "合同公司主体：公司信息表")
	private String company;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 50)
	@Length(max = 50, message = "姓名不能超过50个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String name;
	/**
	 * 姓名拼音
	 */
	@ExcelAttribute(name = "姓名拼音", maxLength = 100)
	@Length(max = 100, message = "姓名拼音不能超过100个字符")
	@ExcelProperty("姓名拼音")
	@Schema(description = "姓名拼音")
	private String nameAc;
	/**
	 * 姓氏拼音
	 */
	@ExcelAttribute(name = "姓氏拼音", maxLength = 50)
	@Length(max = 50, message = "姓氏拼音不能超过50个字符")
	@ExcelProperty("姓氏拼音")
	@Schema(description = "姓氏拼音")
	private String lastNameAc;
	/**
	 * 名字拼音
	 */
	@ExcelAttribute(name = "名字拼音", maxLength = 50)
	@Length(max = 50, message = "名字拼音不能超过50个字符")
	@ExcelProperty("名字拼音")
	@Schema(description = "名字拼音")
	private String firstNameAc;
	/**
	 * 国籍编码
	 */
	@ExcelAttribute(name = "国籍编码", maxLength = 10)
	@Length(max = 10, message = "国籍编码不能超过10个字符")
	@ExcelProperty("国籍编码")
	@Schema(description = "国籍编码")
	private String country;
	/**
	 * 国籍描述
	 */
	@ExcelAttribute(name = "国籍描述", maxLength = 30)
	@Length(max = 30, message = "国籍描述不能超过30个字符")
	@ExcelProperty("国籍描述")
	@Schema(description = "国籍描述")
	private String countryDescr;
	/**
	 * 证件类型编码
	 */
	@ExcelAttribute(name = "证件类型编码", maxLength = 6)
	@Length(max = 6, message = "证件类型编码不能超过6个字符")
	@ExcelProperty("证件类型编码")
	@Schema(description = "证件类型编码")
	private String nationalIdType;
	/**
	 * 证件类型描述
	 */
	@ExcelAttribute(name = "证件类型描述", maxLength = 30)
	@Length(max = 30, message = "证件类型描述不能超过30个字符")
	@ExcelProperty("证件类型描述")
	@Schema(description = "证件类型描述")
	private String nationalIdTypeDescr;
	/**
	 * 证件号码
	 */
	@ExcelAttribute(name = "证件号码", maxLength = 50)
	@Length(max = 50, message = "证件号码不能超过50个字符")
	@ExcelProperty("证件号码")
	@Schema(description = "证件号码")
	private String nationalId;
	/**
	 * 性别（F:女M:男）
	 */
	@ExcelAttribute(name = "性别（F:女M:男）", maxLength = 10)
	@Length(max = 10, message = "性别（F:女M:男）不能超过10个字符")
	@ExcelProperty("性别（F:女M:男）")
	@Schema(description = "性别（F:女M:男）")
	private String sex;
	/**
	 * 个人手机号
	 */
	@ExcelAttribute(name = "个人手机号", maxLength = 30)
	@Length(max = 30, message = "个人手机号不能超过30个字符")
	@ExcelProperty("个人手机号")
	@Schema(description = "个人手机号")
	private String phone;
	/**
	 * 个人邮箱
	 */
	@ExcelAttribute(name = "个人邮箱", maxLength = 100)
	@Length(max = 100, message = "个人邮箱不能超过100个字符")
	@ExcelProperty("个人邮箱")
	@Schema(description = "个人邮箱")
	private String email;
	/**
	 * 直接上级姓名
	 */
	@ExcelAttribute(name = "直接上级姓名", maxLength = 200)
	@Length(max = 200, message = "直接上级姓名不能超过200个字符")
	@ExcelProperty("直接上级姓名")
	@Schema(description = "直接上级姓名")
	private String supervisorName;
	/**
	 * 职务描述
	 */
	@ExcelAttribute(name = "职务描述", maxLength = 50)
	@Length(max = 50, message = "职务描述不能超过50个字符")
	@ExcelProperty("职务描述")
	@Schema(description = "职务描述")
	private String jobcodeDescr;
	/**
	 * 工作地点
	 */
	@ExcelAttribute(name = "工作地点", maxLength = 12)
	@Length(max = 12, message = "工作地点不能超过12个字符")
	@ExcelProperty("工作地点")
	@Schema(description = "工作地点")
	private String workLocation;
	/**
	 * 工作地点描述
	 */
	@ExcelAttribute(name = "工作地点描述", maxLength = 12)
	@Length(max = 12, message = "工作地点描述不能超过12个字符")
	@ExcelProperty("工作地点描述")
	@Schema(description = "工作地点描述")
	private String workLocationDescr;
	/**
	 * 预计入职日期：yyyy-MM-dd
	 */
	@ExcelAttribute(name = "预计入职日期：yyyy-MM-dd", isDate = true)
	@ExcelProperty("预计入职日期：yyyy-MM-dd")
	@Schema(description = "预计入职日期：yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date expEntryDate;
	/**
	 * 部门名称
	 */
	@ExcelAttribute(name = "部门名称", maxLength = 200)
	@Length(max = 200, message = "部门名称不能超过200个字符")
	@ExcelProperty("部门名称")
	@Schema(description = "部门名称")
	private String deptName;
	/**
	 * 基本工资,两位小数
	 */
	@ExcelAttribute(name = "基本工资,两位小数")
	@ExcelProperty("基本工资,两位小数")
	@Schema(description = "基本工资,两位小数")
	private BigDecimal basePay;
	/**
	 * 绩效工资,两位小数
	 */
	@ExcelAttribute(name = "绩效工资,两位小数")
	@ExcelProperty("绩效工资,两位小数")
	@Schema(description = "绩效工资,两位小数")
	private BigDecimal perfomPay;
	/**
	 * 年终奖月数
	 */
	@ExcelAttribute(name = "年终奖月数")
	@ExcelProperty("年终奖月数")
	@Schema(description = "年终奖月数")
	private Integer yearBonusMonth;
	/**
	 * 社保缴纳地编码
	 */
	@ExcelAttribute(name = "社保缴纳地编码", maxLength = 12)
	@Length(max = 12, message = "社保缴纳地编码不能超过12个字符")
	@ExcelProperty("社保缴纳地编码")
	@Schema(description = "社保缴纳地编码")
	private String socialInsuranceLocation;
	/**
	 * 社保缴纳地
	 */
	@ExcelAttribute(name = "社保缴纳地", maxLength = 30)
	@Length(max = 30, message = "社保缴纳地不能超过30个字符")
	@ExcelProperty("社保缴纳地")
	@Schema(description = "社保缴纳地")
	private String socialInsuranceLocationDescr;
	/**
	 * 社保基数
	 */
	@ExcelAttribute(name = "社保基数")
	@ExcelProperty("社保基数")
	@Schema(description = "社保基数")
	private BigDecimal socialInsuranceBase;
	/**
	 * 公积金基数
	 */
	@ExcelAttribute(name = "公积金基数")
	@ExcelProperty("公积金基数")
	@Schema(description = "公积金基数")
	private BigDecimal houseAccFundBaseMax;
	/**
	 * 是否转正后缴纳公积金(Y:是 N:否)
	 */
	@ExcelAttribute(name = "是否转正后缴纳公积金(Y:是 N:否)", maxLength = 1)
	@Length(max = 1, message = "是否转正后缴纳公积金(Y:是 N:否)不能超过1个字符")
	@ExcelProperty("是否转正后缴纳公积金(Y:是 N:否)")
	@Schema(description = "是否转正后缴纳公积金(Y:是 N:否)")
	private String beRegularEmpPay;
	/**
	 * 申请人邮箱
	 */
	@ExcelAttribute(name = "申请人邮箱", maxLength = 60)
	@Length(max = 60, message = "申请人邮箱不能超过60个字符")
	@ExcelProperty("申请人邮箱")
	@Schema(description = "申请人邮箱")
	private String applyUserEmail;
	/**
	 * 删除标记
	 */
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@ExcelProperty("删除标记")
	@Schema(description = "删除标记")
	@TableLogic
	private String delFlag;

}
