/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 瓜子系统交互任务跟进表
 *
 * @author cyx
 * @date 2025-07-09 17:03:50
 */
@Data
@TableName("t_gz_push_entry")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子系统交互任务跟进表")
public class TGzPushEntry extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 流程ID（瓜子推过来的主键）
	 */
	@ExcelAttribute(name = "流程ID（瓜子推过来的主键）", isNotEmpty = true, errorInfo = "流程ID（瓜子推过来的主键）不能为空", maxLength = 32)
	@NotBlank(message = "流程ID（瓜子推过来的主键）不能为空")
	@Length(max = 32, message = "流程ID（瓜子推过来的主键）不能超过32个字符")
	@ExcelProperty("流程ID（瓜子推过来的主键）")
	@Schema(description = "流程ID（瓜子推过来的主键）")
	private String bizId;
	/**
	 * 交互任务类型（4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，97：档案信息推送，13：待签署，8：合同信息推送，99：合同附件推送）
	 */
	@ExcelAttribute(name = "交互任务类型（4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，97：档案信息推送，13：待签署，8：合同信息推送，99：合同附件推送）", isNotEmpty = true, errorInfo = "交互任务类型（4：待接受Offer，5：拒绝Offer，7：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，97：档案信息推送，13：待签署，8：合同信息推送，99：合同附件推送）不能为空", maxLength = 2)
	@NotBlank(message = "交互任务类型（4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，97：档案信息推送，13：待签署，8：合同信息推送，99：合同附件推送）不能为空")
	@Length(max = 2, message = "交互任务类型（4：待接受Offer，5：拒绝Offer，7：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，97：档案信息推送，13：待签署，8：合同信息推送，99：合同附件推送）不能超过2个字符")
	@ExcelProperty("交互任务类型（4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，97：档案信息推送，13：待签署，8：合同信息推送，99：合同附件推送）")
	@Schema(description = "交互任务类型（4：待接受Offer，5：拒绝Offer，6：接受offer，9：候选人填写信息，10：取消offer，12：候选人信息审核，97：档案信息推送，13：待签署，8：合同信息推送，99：合同附件推送）")
	private String taskType;
	/**
	 * 推送状态（0:推送成功1:推送失败2:待推送3 推送中）
	 */
	@ExcelAttribute(name = "推送状态（0:推送成功1:推送失败2:待推送）", isNotEmpty = true, errorInfo = "推送状态（0:推送成功1:推送失败2:待推送）不能为空", maxLength = 1)
	@NotBlank(message = "推送状态（0:推送成功1:推送失败2:待推送）不能为空")
	@Length(max = 1, message = "推送状态（0:推送成功1:推送失败2:待推送）不能超过1个字符")
	@ExcelProperty("推送状态（0:推送成功1:推送失败2:待推送）")
	@Schema(description = "推送状态（0:推送成功1:推送失败2:待推送3 推送中）")
	private String pushStatus;
	/**
	 * 推送时间
	 */
	@ExcelAttribute(name = "推送时间", isDate = true)
	@ExcelProperty("推送时间")
	@Schema(description = "推送时间")
	private LocalDateTime pushTime;
	/**
	 * 失败原因
	 */
	@ExcelAttribute(name = "失败原因", maxLength = 512)
	@Length(max = 512, message = "失败原因不能超过512个字符")
	@ExcelProperty("失败原因")
	@Schema(description = "失败原因")
	private String failReason;
	/**
	 * 推送报文，JSON格式的字符串
	 */
	@ExcelAttribute(name = "推送报文，JSON格式的字符串")
	@ExcelProperty("推送报文，JSON格式的字符串")
	@Schema(description = "推送报文，JSON格式的字符串")
	private String pushData;
	/**
	 * 对方响应的报文，JSON格式的字符串
	 */
	@ExcelAttribute(name = "对方响应的报文，JSON格式的字符串")
	@ExcelProperty("对方响应的报文，JSON格式的字符串")
	@Schema(description = "对方响应的报文，JSON格式的字符串")
	private String responseData;
	/**
	 * 删除标记
	 */
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@ExcelProperty("删除标记")
	@Schema(description = "删除标记")
	private String delFlag;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 50)
	@Length(max = 50, message = "姓名不能超过50个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String name;
	/**
	 * 证件号码
	 */
	@ExcelAttribute(name = "证件号码", maxLength = 50)
	@Length(max = 50, message = "证件号码不能超过50个字符")
	@ExcelProperty("证件号码")
	@Schema(description = "证件号码")
	private String nationalId;

}
