/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 预入职-项目档案表
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Data
@TableName("t_pre_employee_project")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-项目档案表")
public class TPreEmployeeProject extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 人员档案主表id
	 */
	@ExcelAttribute(name = "人员档案主表id", isNotEmpty = true, errorInfo = "人员档案主表id不能为空", maxLength = 32)
	@NotBlank(message = "人员档案主表id不能为空")
	@Length(max = 32, message = "人员档案主表id不能超过32个字符")
	@ExcelProperty("人员档案主表id")
	@Schema(description = "人员档案主表id")
	private String empId;
	/**
	 * 员工主码（系统自动生成：ZM+年月日+5位数字）
	 */
	@ExcelAttribute(name = "员工主码（系统自动生成：ZM+年月日+5位数字）", isNotEmpty = true, errorInfo = "员工主码（系统自动生成：ZM+年月日+5位数字）不能为空", maxLength = 16)
	@NotBlank(message = "员工主码（系统自动生成：ZM+年月日+5位数字）不能为空")
	@Length(max = 16, message = "员工主码（系统自动生成：ZM+年月日+5位数字）不能超过16个字符")
	@ExcelProperty("员工主码（系统自动生成：ZM+年月日+5位数字）")
	@Schema(description = "员工主码（系统自动生成：ZM+年月日+5位数字）")
	private String empCode;
	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@ExcelAttribute(name = "员工类型（字典值，0外包1派遣2代理）", isNotEmpty = true, errorInfo = "员工类型（字典值，0外包1派遣2代理）不能为空", maxLength = 2)
	@NotBlank(message = "员工类型（字典值，0外包1派遣2代理）不能为空")
	@Length(max = 2, message = "员工类型（字典值，0外包1派遣2代理）不能超过2个字符")
	@ExcelProperty("员工类型（字典值，0外包1派遣2代理）")
	@Schema(description = "员工类型（字典值，0外包1派遣2代理）")
	private String empNatrue;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 30)
	@NotBlank(message = "员工姓名不能为空")
	@Length(max = 30, message = "员工姓名不能超过30个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 身份证号码
	 */
	@ExcelAttribute(name = "身份证号码", isNotEmpty = true, errorInfo = "身份证号码不能为空", maxLength = 20)
	@NotBlank(message = "身份证号码不能为空")
	@Length(max = 20, message = "身份证号码不能超过20个字符")
	@ExcelProperty("身份证号码")
	@Schema(description = "身份证号码")
	private String empIdcard;
	/**
	 * 开户行
	 */
	@ExcelAttribute(name = "开户行", maxLength = 50)
	@Length(max = 50, message = "开户行不能超过50个字符")
	@ExcelProperty("开户行")
	@Schema(description = "开户行")
	private String bankName;
	/**
	 * 支行
	 */
	@ExcelAttribute(name = "支行", maxLength = 50)
	@Length(max = 50, message = "支行不能超过50个字符")
	@ExcelProperty("支行")
	@Schema(description = "支行")
	private String bankSubName;
	/**
	 * 银行卡号
	 */
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	@Length(max = 50, message = "银行卡号不能超过50个字符")
	@ExcelProperty("银行卡号")
	@Schema(description = "银行卡号")
	private String bankNo;
	/**
	 * 减项操作人id
	 */
	@ExcelAttribute(name = "减项操作人id", maxLength = 32)
	@Length(max = 32, message = "减项操作人id不能超过32个字符")
	@ExcelProperty("减项操作人id")
	@Schema(description = "减项操作人id")
	private String leaveUser;
	/**
	 * 减项时间
	 */
	@ExcelAttribute(name = "减项时间", isDate = true)
	@ExcelProperty("减项时间")
	@Schema(description = "减项时间")
	private Date leaveTime;
	/**
	 * 减项原因
	 */
	@ExcelAttribute(name = "减项原因", maxLength = 32)
	@Length(max = 32, message = "减项原因不能超过32个字符")
	@ExcelProperty("减项原因")
	@Schema(description = "减项原因")
	private String leaveReason;
	/**
	 * 减项备注
	 */
	@ExcelAttribute(name = "减项备注", maxLength = 255)
	@Length(max = 255, message = "减项备注不能超过255个字符")
	@ExcelProperty("减项备注")
	@Schema(description = "减项备注")
	private String leaveRemark;
	/**
	 * 员工编码
	 */
	@ExcelAttribute(name = "员工编码", maxLength = 20)
	@Length(max = 20, message = "员工编码不能超过20个字符")
	@ExcelProperty("员工编码")
	@Schema(description = "员工编码")
	private String empNo;
	/**
	 * 客户id
	 */
	@ExcelAttribute(name = "客户id", maxLength = 32)
	@Length(max = 32, message = "客户id不能超过32个字符")
	@ExcelProperty("客户id")
	@Schema(description = "客户id")
	private String unitId;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelProperty("客户名称")
	@Schema(description = "客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Length(max = 32, message = "客户编码不能超过32个字符")
	@ExcelProperty("客户编码")
	@Schema(description = "客户编码")
	private String unitNo;
	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id", maxLength = 32)
	@Length(max = 32, message = "项目id不能超过32个字符")
	@ExcelProperty("项目id")
	@Schema(description = "项目id")
	private String deptId;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码不能为空", maxLength = 30)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 30, message = "项目编码不能超过30个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 业务类型一级分类
	 */
	@ExcelAttribute(name = "业务类型一级分类", maxLength = 32)
	@Length(max = 32, message = "业务类型一级分类不能超过32个字符")
	@ExcelProperty("业务类型一级分类")
	@Schema(description = "业务类型一级分类")
	private String businessPrimaryType;
	/**
	 * 业务类型二级分类
	 */
	@ExcelAttribute(name = "业务类型二级分类", maxLength = 32)
	@Length(max = 32, message = "业务类型二级分类不能超过32个字符")
	@ExcelProperty("业务类型二级分类")
	@Schema(description = "业务类型二级分类")
	private String businessSecondType;
	/**
	 * 业务类型三级分类
	 */
	@ExcelAttribute(name = "业务类型三级分类", maxLength = 32)
	@Length(max = 32, message = "业务类型三级分类不能超过32个字符")
	@ExcelProperty("业务类型三级分类")
	@Schema(description = "业务类型三级分类")
	private String businessThirdType;
	/**
	 * 合同类型（字典值）
	 */
	@ExcelAttribute(name = "合同类型（字典值）", isNotEmpty = true, errorInfo = "合同类型（字典值）不能为空", maxLength = 2)
	@NotBlank(message = "合同类型（字典值）不能为空")
	@Length(max = 2, message = "合同类型（字典值）不能超过2个字符")
	@ExcelProperty("合同类型（字典值）")
	@Schema(description = "合同类型（字典值）")
	private String contractType;
	/**
	 * 工时制
	 */
	@ExcelAttribute(name = "工时制", maxLength = 1)
	@Length(max = 1, message = "工时制不能超过1个字符")
	@ExcelProperty("工时制")
	@Schema(description = "工时制")
	private String workingHours;
	/**
	 * 就职岗位
	 */
	@ExcelAttribute(name = "就职岗位", maxLength = 50)
	@Length(max = 50, message = "就职岗位不能超过50个字符")
	@ExcelProperty("就职岗位")
	@Schema(description = "就职岗位")
	private String post;
	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期", isDate = true)
	@ExcelProperty("入职日期")
	@Schema(description = "入职日期")
	private Date enjoinDate;
	/**
	 * 试用期（单位月）
	 */
	@ExcelAttribute(name = "试用期（单位月）", maxLength = 4)
	@Length(max = 4, message = "试用期（单位月）不能超过4个字符")
	@ExcelProperty("试用期（单位月）")
	@Schema(description = "试用期（单位月）")
	private String tryPeriod;
	/**
	 * 项目档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬）
	 */
	@ExcelAttribute(name = "项目档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬）", maxLength = 5)
	@Length(max = 5, message = "项目档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬）不能超过5个字符")
	@ExcelProperty("项目档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬）")
	@Schema(description = "项目档案来源（字典：4人员档案新建、5项目档案新建、1社保/公积金、3商险、2薪酬）")
	private String projectSource;
	/**
	 * 计税月份
	 */
	@ExcelAttribute(name = "计税月份", maxLength = 6)
	@Length(max = 6, message = "计税月份不能超过6个字符")
	@ExcelProperty("计税月份")
	@Schema(description = "计税月份")
	private String taxMonth;
	/**
	 * 项目档案状态（0草稿、1已审核）
	 */
	@ExcelAttribute(name = "项目档案状态（0草稿、1已审核）", isNotEmpty = true, errorInfo = "项目档案状态（0草稿、1已审核）不能为空")
	@NotBlank(message = "项目档案状态（0草稿、1已审核）不能为空")
	@ExcelProperty("项目档案状态（0草稿、1已审核）")
	@Schema(description = "项目档案状态（0草稿、1已审核）")
	private Integer status;
	/**
	 * 项目状态（0正常；1已减项）
	 */
	@ExcelAttribute(name = "项目状态（0正常；1已减项）")
	@ExcelProperty("项目状态（0正常；1已减项）")
	@Schema(description = "项目状态（0正常；1已减项）")
	private Integer projectStatus;
	/**
	 * 员工合同状态（字典:0初始）
	 */
	@ExcelAttribute(name = "员工合同状态（字典:0初始）")
	@ExcelProperty("员工合同状态（字典:0初始）")
	@Schema(description = "员工合同状态（字典:0初始）")
	private Integer contractStatus;
	/**
	 * 近3个月发薪（0无；1是；2否）
	 */
	@ExcelAttribute(name = "近3个月发薪（0无；1是；2否）")
	@ExcelProperty("近3个月发薪（0无；1是；2否）")
	@Schema(description = "近3个月发薪（0无；1是；2否）")
	private Integer salaryStatus;
	/**
	 * 是否删除 0否/1是
	 */
	@ExcelAttribute(name = "是否删除 0否/1是", isNotEmpty = true, errorInfo = "是否删除 0否/1是不能为空", maxLength = 1)
	@NotBlank(message = "是否删除 0否/1是不能为空")
	@Length(max = 1, message = "是否删除 0否/1是不能超过1个字符")
	@ExcelProperty("是否删除 0否/1是")
	@Schema(description = "是否删除 0否/1是")
	private String deleteFlag;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 100)
	@Length(max = 100, message = "备注不能超过100个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;
	/**
	 * 商险状态（字典）
	 */
	@ExcelAttribute(name = "商险状态（字典）")
	@ExcelProperty("商险状态（字典）")
	@Schema(description = "商险状态（字典）")
	private Integer insuranceStatus;
	/**
	 * 社保状态（字典）
	 */
	@ExcelAttribute(name = "社保状态（字典）")
	@ExcelProperty("社保状态（字典）")
	@Schema(description = "社保状态（字典）")
	private Integer socialStatus;
	/**
	 * 公积金状态（字典）
	 */
	@ExcelAttribute(name = "公积金状态（字典）")
	@ExcelProperty("公积金状态（字典）")
	@Schema(description = "公积金状态（字典）")
	private Integer fundStatus;
	/**
	 * 是否同步减档（1是 0否）
	 */
	@ExcelAttribute(name = "是否同步减档（1是 0否）")
	@ExcelProperty("是否同步减档（1是 0否）")
	@Schema(description = "是否同步减档（1是 0否）")
	private Integer isLeaveEmployee;
	/**
	 * 社保-省
	 */
	@ExcelAttribute(name = "社保-省")
	@ExcelProperty("社保-省")
	@Schema(description = "社保-省")
	private Integer socialProvince;
	/**
	 * 社保-市
	 */
	@ExcelAttribute(name = "社保-市")
	@ExcelProperty("社保-市")
	@Schema(description = "社保-市")
	private Integer socialCity;
	/**
	 * 社保-县
	 */
	@ExcelAttribute(name = "社保-县")
	@ExcelProperty("社保-县")
	@Schema(description = "社保-县")
	private Integer socialTown;
	/**
	 * 标签
	 */
	@ExcelAttribute(name = "标签", maxLength = 20)
	@Length(max = 20, message = "标签不能超过20个字符")
	@ExcelProperty("标签")
	@Schema(description = "标签")
	private String empLabel;

}
