/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * HCM档案子Vo
 * 不良记录
 * @author chenyuxi
 * @date 2025-08-08
 */
@Data
@ColumnWidth(30)
public class HcmArchiveBadRecordVo implements Serializable {

	private static final long serialVersionUID = 1L;

	@Schema(description = "发生时间")
	private String happenDate;

	@Schema(description = "不良记录描述")
	private String remark;

	@Schema(description = "身份证号")
	private String empIdCard;

}
