/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * HCM档案子Vo
 *
 * @author hgw
 * @date 2023-11-23 12:02:03
 */
@Data
@ColumnWidth(30)
public class HcmArchiveFamilyVo implements Serializable {

	private static final long serialVersionUID = 1L;

	// 与本人关系
	@Schema(description = "称谓")
	private String relationName;
	// 成员姓名
	@Schema(description = "姓名")
	private String trueName;
	// 出生日期
	@Schema(description = "出生年月")
	private String bornTime;
	// 无
	@Schema(description = "政治面貌")
	private String political;
	// 工作单位
	@Schema(description = "工作/学习单位")
	private String company;
	// 无
	@Schema(description = "职位/职务")
	private String jobName;

	@Schema(description = "与本人关系")
	private String relation;

	@Schema(description = "身份证号")
	private String empIdCard;

}
