/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * HCM档案子Vo
 *
 * @author hgw
 * @date 2023-11-23 12:02:03
 */
@Data
@ColumnWidth(30)
public class HcmContractVo implements Serializable {

	private static final long serialVersionUID = 1L;

	@Schema(description = "合同类型")
	private String contractType;
	// 签订期限
	@Schema(description = "期限类型")
	private String termType;
	// 无
	@Schema(description = "合同签订日期")
	private String contractDate;
	// 合同甲方
	@Schema(description = "合同公司")
	private String contractCompany;
	// 合同编码
	@Schema(description = "合同编号")
	private String contractCode;
	// 合同起始日期
	@Schema(description = "合同开始日期")
	private String startDate;
	// 合同截止日期
	@Schema(description = "合同结束日期")
	private String endDate;

	@Schema(description = "合同状态")
	private String contractStatus;
	// 附件
	@Schema(description = "合同附件")
	private String annexArray;
	// 无
	@Schema(description = "合同负责人")
	private String contractOwner;

}
