/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 风险管控比例
 *
 * @author huyc
 * @date 2024-09-27 15:54:40
 */
@Data
@ColumnWidth(30)
public class RiskMonitorPerVo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 总项目数
	 */
	@Schema(description = "总项目数")
	private String deptNum;

	/**
	 * 存在风险项目数
	 */
	@Schema(description = "存在风险项目数")
	private String riskDeptNum;

	/**
	 * 存在风险项目占比
	 */
	@Schema(description = "存在风险项目占比")
	private String riskDeptPer;

	/**
	 * 商险漏买项目数
	 */
	@Schema(description = "商险漏买项目数")
	private String riskInsuraceNum;

	/**
	 * 商险漏买项目占比
	 */
	@Schema(description = "商险漏买占比")
	private String riskInsuracePer;

}
