/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 购买标准配置表
 *
 * @author fxj
 * @date 2025-04-01 10:14:09
 */
@Data
public class TAutoInsurStandardVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键")
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String id;
	/**
	 * 配置名称
	 */
	@NotBlank(message = "配置名称不能为空")
	@Length(max = 50, message = "配置名称不能超过50 个字符")
	@ExcelAttribute(name = "配置名称", isNotEmpty = true, errorInfo = "配置名称 不能为空", maxLength = 50)
	@Schema(description = "配置名称")
	@ExcelProperty("配置名称")
	private String name;
	/**
	 * 保险公司
	 */
	@NotBlank(message = "保险公司不能为空")
	@ExcelAttribute(name = "保险公司", isNotEmpty = true, errorInfo = "保险公司不能为空")
	@Schema(description = "保险公司")
	@ExcelProperty("保险公司")
	private Integer company;
	/**
	 * 险种，下拉选项
	 */
	@NotBlank(message = "险种不能为空")
	@ExcelAttribute(name = "险种", isNotEmpty = true, errorInfo = "险种不能为空")
	@Schema(description = "险种")
	@ExcelProperty("险种")
	private Integer riskType;
	/**
	 * 购买标准，多值逗号分隔
	 */
	@NotBlank(message = "购买标准不能为空")
	@Length(max = 100, message = "购买标准不能超过100 个字符")
	@ExcelAttribute(name = "购买标准", isNotEmpty = true, errorInfo = "购买标准不能为空", maxLength = 100)
	@Schema(description = "购买标准")
	@ExcelProperty("购买标准")
	private String standard;
	/**
	 * 派单-省
	 */
	@NotBlank(message = "派单-省 不能为空")
	@ExcelAttribute(name = "派单-省", isNotEmpty = true, errorInfo = "派单-省 不能为空")
	@Schema(description = "派单-省")
	@ExcelProperty("派单-省")
	private Integer buyProvince;
	/**
	 * 派单-市
	 */
	@NotBlank(message = "派单-市 不能为空")
	@ExcelAttribute(name = "派单-市", isNotEmpty = true, errorInfo = "派单-市 不能为空")
	@Schema(description = "派单-市")
	@ExcelProperty("派单-市")
	private Integer buyCity;
	/**
	 * 派单-县
	 */
	@ExcelAttribute(name = "派单-县")
	@Schema(description = "派单-县")
	@ExcelProperty("派单-县")
	private Integer buyTown;
	/**
	 * 商险配置表ID
	 */
	@Length(max = 32, message = "商险配置表ID 不能超过32 个字符")
	@ExcelAttribute(name = "商险配置表ID" )
	@Schema(description = "商险配置表ID")
	@ExcelProperty("商险配置表ID")
	private String mainId;

}
