/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author fxj
 * @date 2024-06-17 14:29:11
 */
@Data
public class TEmpContactInfoVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * empId
	 */
	@Length(max = 32, message = "empId 不能超过32 个字符")
	@ExcelAttribute(name = "empId", maxLength = 32)
	@Schema(description = "empId")
	@ExcelProperty("empId")
	private String empId;

	/**
	 * 身份证
	 */
	@ExcelAttribute(name = "身份证", isNotEmpty = false, errorInfo = "身份证不能为空", maxLength = 20)
	@NotBlank(message = "身份证不能为空")
	@Length(max = 20, message = "身份证不能超过20个字符")
	@ExcelProperty("身份证")
	@Schema(description = "身份证")
	private String empIdcard;

	/**
	 * 姓名
	 */
	@NotBlank(message = "姓名 不能为空")
	@Length(max = 20, message = "姓名 不能超过20 个字符")
	@ExcelAttribute(name = "姓名", isNotEmpty = true, errorInfo = "姓名 不能为空", maxLength = 20)
	@Schema(description = "姓名")
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 与本人关系
	 */
	@NotBlank(message = "与本人关系 不能为空")
	@Length(max = 50, message = "与本人关系 不能超过50 个字符")
	@ExcelAttribute(name = "与本人关系", isNotEmpty = true, errorInfo = "与本人关系 不能为空", maxLength = 50)
	@Schema(description = "与本人关系")
	@ExcelProperty("与本人关系")
	private String relationType;
	/**
	 * 联系地址-街道、详情
	 */
	@NotBlank(message = "联系地址-街道、详情 不能为空")
	@Length(max = 100, message = "联系地址-街道、详情 不能超过100 个字符")
	@ExcelAttribute(name = "联系地址-街道、详情", isNotEmpty = true, errorInfo = "联系地址-街道、详情 不能为空", maxLength = 100)
	@Schema(description = "联系地址-街道、详情")
	@ExcelProperty("联系地址-街道、详情")
	private String address;
	/**
	 * 联系电话
	 */
	@NotBlank(message = "联系电话 不能为空")
	@Length(max = 20, message = "联系电话 不能超过20 个字符")
	@ExcelAttribute(name = "联系电话", isNotEmpty = true, errorInfo = "联系电话 不能为空", maxLength = 20)
	@Schema(description = "联系电话")
	@ExcelProperty("联系电话")
	private String tel;
	/**
	 * 创建者
	 */
	@Length(max = 64, message = "创建者 不能超过64 个字符")
	@ExcelAttribute(name = "创建者", maxLength = 64)
	@Schema(description = "创建者")
	@ExcelProperty("创建者")
	private String createBy;
	/**
	 * 更新人
	 */
	@Length(max = 64, message = "更新人 不能超过64 个字符")
	@ExcelAttribute(name = "更新人", maxLength = 64)
	@Schema(description = "更新人")
	@ExcelProperty("更新人")
	private String updateBy;
	/**
	 * 创建人姓名
	 */
	@Length(max = 32, message = "创建人姓名 不能超过32 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 32)
	@Schema(description = "创建人姓名")
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@Schema(description = "创建时间")
	@ExcelProperty("创建时间")
	private Date createTime;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@Schema(description = "更新时间")
	@ExcelProperty("更新时间")
	private Date updateTime;

}
