/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractAreaRes;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 合同地市权限配置表
 *
 * @author fxj
 * @date 2022-11-01 10:30:12
 */
@Data
public class TEmpContractAreaExportVo  implements Serializable {

	/**
	 * 登录人姓名
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核人")
	@Schema(description = "审核人")
	private String userName;
	/**
	 * 申請人所在部门
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "审核人所在部门")
	@ExcelProperty("审核人所在部门")
	@Schema(description = "审核人所在部门")
	private String organName;
	/**
	 * 档案-省
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "档案-省",isArea = true, isNotEmpty = true, errorInfo = "档案-省不能为空")
	@NotBlank(message = "档案-省不能为空")
	@ExcelProperty("档案-省")
	@Schema(description = "档案-省")
	private String fileProvince;
	/**
	 * 档案-市
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "档案-市",isArea = true,parentField = "fileProvince")
	@ExcelProperty("档案-市")
	@Schema(description = "档案-市")
	private String fileCity;
	/**
	 * 档案-县
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "档案-县",isArea = true,parentField = "fileCity")
	@ExcelProperty("档案-县")
	@Schema(description = "档案-县")
	private String fileTown;



	/**
	 * 状态  0 启用  1 禁用
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "授权状态",readConverterExp = "0=启用,1=禁用")
	@ExcelProperty("授权状态")
	@Schema(description = "授权状态：0 启用  1 禁用")
	private String status;

}
