package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author fxj
 * @Date 2022/6/27
 * @Description
 * @Version 1.0
 */
@Data
public class TWorkHandlerInfoVo implements Serializable {

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码不能为空", maxLength = 32)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 32, message = "项目编码不能超过32个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String departNo;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", isNotEmpty = true, errorInfo = "项目名称不能为空", maxLength = 50)
	@NotBlank(message = "项目名称不能为空")
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	private String departName;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "员工身份证", maxLength = 32)
	@Length(max = 32, message = "员工身份证不能超过32个字符")
	@ExcelProperty("员工身份证")
	@Schema(description = "员工身份证")
	private String empIdcard;
	/**
	 * 联动端口
	 */
	@ExcelAttribute(name = "联动端口", maxLength = 8)
	@Length(max = 8, message = "联动端口不能超过8个字符")
	@ExcelProperty("联动端口")
	@Schema(description = "联动端口")
	private String infoFrom;
	/**
	 * 操作人
	 */
	@ExcelAttribute(name = "操作人", maxLength = 32)
	@Length(max = 32, message = "操作人不能超过32个字符")
	@ExcelProperty("操作人")
	@Schema(description = "操作人")
	private String operUser;
	/**
	 * 操作时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "操作时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("操作时间")
	private LocalDateTime operTime;
	/**
	 * 执行结果
	 */
	@ExcelAttribute(name = "执行结果")
	@Length(max = 5, message = "执行结果不能超过5个字符")
	@ExcelProperty("执行结果")
	@Schema(description = "执行结果")
	private String operResult;
	/**
	 * 执行详情
	 */
	@ExcelAttribute(name = "执行详情", maxLength = 255)
	@Length(max = 255, message = "执行详情不能超过255个字符")
	@ExcelProperty("执行详情")
	@Schema(description = "执行详情")
	private String operInfo;
	/**
	 * 原因
	 */
	@ExcelAttribute(name = "原因", maxLength = 255)
	@Length(max = 255, message = "原因不能超过255个字符")
	@ExcelProperty("原因")
	@Schema(description = "原因")
	private String reason;

}
