package com.yifu.cloud.plus.v1.yifu.archives.config;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.common.OpenId;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.client.ServiceClient;
import com.fasc.open.api.v5_1.client.TemplateClient;
import com.fasc.open.api.v5_1.req.template.GetSignTemplateListReq;
import com.fasc.open.api.v5_1.req.template.SignTemplateListFilterInfo;
import com.fasc.open.api.v5_1.res.service.AccessTokenRes;
import com.fasc.open.api.v5_1.res.template.SignTemplateListInfo;
import com.fasc.open.api.v5_1.res.template.SignTemplateListRes;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.CheckedException;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author: hgw
 * @Date: 2025-9-25 14:24:53
 * @return: 企业法大大专业版配置
 **/
@Configuration
@Data
@Slf4j
public class FascConfig {

	@Value("${fasc.appId}")
	private String appId;
	@Value("${fasc.appSecret}")
	private String appSecret;
	@Value("${fasc.appUrl}")
	private String appUrl;
	@Value("${fasc.openId}")
	private String openId;


	/*@Autowired
	private RedisTemplate redisTemplate;


	*//*public static void main(String[] args) throws ApiException {
		String appId = "80003662";
		String appSecret = "DXREUVHOLEFJMWLGYFGF1JKID8YCEDWZ";
		OpenApiClient openApiClient = new OpenApiClient(appId, appSecret, "https://uat-api.fadada.com/api/v5");
		ServiceClient serviceClient = new ServiceClient(openApiClient);
		BaseRes<AccessTokenRes> res = serviceClient.getAccessToken();
		String token = null;
		if (res != null && res.isSuccess() && res.getData() != null && res.getData().getAccessToken() != null) {
			token = res.getData().getAccessToken();
		}
		System.out.println(token);
	}*//*

	*//**
	 * @Description: 获取token
	 * @Author: huyc
	 * @Date: 2023/7/28 14:46
	 * @return: java.lang.String
	 **//*
	public String getFascToken(OpenApiClient openApiClient) throws ApiException {
		String tokenKey = CacheConstants.FASC_ACCOSS_TOKEN;
		Object wxToken = redisTemplate.opsForValue().get(tokenKey);
		if (null != wxToken) {
			return String.valueOf(wxToken);
		}
		if (openApiClient == null) {
			openApiClient = new OpenApiClient(appId, appSecret, appUrl);
		}
		ServiceClient serviceClient = new ServiceClient(openApiClient);
		BaseRes<AccessTokenRes> res = serviceClient.getAccessToken();
		String token = null;
		if (res != null && res.isSuccess() && res.getData() != null && res.getData().getAccessToken() != null) {
			token = res.getData().getAccessToken();
		}
		if (Common.isEmpty(token)) {
			throw new CheckedException("获取法大大专业版token失败");
		}
		redisTemplate.opsForValue().set(tokenKey, token);
		redisTemplate.expire(tokenKey, 3600, TimeUnit.SECONDS);
		return token;
	}

	*//**
	 * @Author: hgw
	 * @Date: 2025-9-25 14:11:06
	 * @Description: 移除法大大专业版accossToken
	 * @return: java.lang.String
	 **//*
	public void removeFascToken() {
		redisTemplate.delete(CacheConstants.FASC_ACCOSS_TOKEN);
	}

	public List<SignTemplateListInfo> getTemplateList(String templateName) throws ApiException {
		OpenApiClient openApiClient = new OpenApiClient(appId, appSecret, appUrl);
		TemplateClient templateClient = new TemplateClient(openApiClient) ;
		String accessToken = this.getFascToken(openApiClient);

		GetSignTemplateListReq getSignTemplateListReq =  new GetSignTemplateListReq() ;
		getSignTemplateListReq.setListPageNo(1) ;
		getSignTemplateListReq.setListPageSize(100) ;
		OpenId ownerId =  new OpenId() ;
		ownerId.setIdType(CacheConstants.FASC_ID_TYPE) ;
		ownerId.setOpenId(openId) ;
		getSignTemplateListReq.setOwnerId(ownerId) ;
		SignTemplateListFilterInfo signTemplateListFilterInfo =  new SignTemplateListFilterInfo();
		if (Common.isNotNull(templateName)) {
			// 签署任务模板名称，如果传了该参数，会根据名称模糊匹配查询，长度最大100个字符。
			signTemplateListFilterInfo.setSignTemplateName(templateName) ;
		} else {
			signTemplateListFilterInfo.setSignTemplateName("") ;
		}
		getSignTemplateListReq.setListFilter(signTemplateListFilterInfo) ;
		getSignTemplateListReq.setAccessToken(accessToken) ;

		BaseRes<SignTemplateListRes> res = templateClient.getSignTemplateList(getSignTemplateListReq) ;
		List<SignTemplateListInfo> list = null;
		if (res != null && res.isSuccess() && res.getData() != null && res.getData().getSignTemplates() != null
				&& !res.getData().getSignTemplates().isEmpty()) {
			list = res.getData().getSignTemplates();
			if (res.getData().getListPageCount() != null ) {
				int listPageCount = res.getData().getListPageCount();
				// 超过1页的循环查询
				if (listPageCount > 1) {
					for (int i=2; i<=listPageCount; i++) {
						getSignTemplateListReq.setListPageNo(i) ;
						res = templateClient.getSignTemplateList(getSignTemplateListReq) ;
						if (res.getData().getSignTemplates() != null && !res.getData().getSignTemplates().isEmpty()) {
							list.addAll(res.getData().getSignTemplates());
						}
					}
				}
			}
		}
		return list;
	}*/

}
