/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractTemplateFile;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddContractTemplateFileService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


/**
 * 法大大员工合同模板文件表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/fddcontracttemplatefile" )
@Tag(name = "法大大员工合同模板文件表管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class FddContractTemplateFileController {

    private final FddContractTemplateFileService fddContractTemplateFileService;

    /**
     * 分页查询
     * @param page 分页对象
     * @param fddContractTemplateFile 法大大员工合同模板文件表
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page" )
    public R getFddContractTemplateFilePage(Page page, FddContractTemplateFile fddContractTemplateFile) {
        return R.ok(fddContractTemplateFileService.page(page, Wrappers.query(fddContractTemplateFile)));
    }


    /**
     * 通过id查询法大大员工合同模板文件表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_fddcontracttemplatefile_get')")
    @GetMapping("/{id}" )
    public R getById(@PathVariable("id" ) String id) {
        return R.ok(fddContractTemplateFileService.getById(id));
    }

    /**
     * 新增法大大员工合同模板文件表
     * @param fddContractTemplateFile 法大大员工合同模板文件表
     * @return R
     */
    @Operation(summary = "新增法大大员工合同模板文件表", description = "新增法大大员工合同模板文件表：hasPermission('demo_fddcontracttemplatefile_add')")
    @SysLog("新增法大大员工合同模板文件表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_fddcontracttemplatefile_add')" )
    public R save(@RequestBody FddContractTemplateFile fddContractTemplateFile) {
        return R.ok(fddContractTemplateFileService.save(fddContractTemplateFile));
    }

    /**
     * 修改法大大员工合同模板文件表
     * @param fddContractTemplateFile 法大大员工合同模板文件表
     * @return R
     */
    @Operation(summary = "修改法大大员工合同模板文件表", description = "修改法大大员工合同模板文件表：hasPermission('demo_fddcontracttemplatefile_edit')")
    @SysLog("修改法大大员工合同模板文件表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_fddcontracttemplatefile_edit')" )
    public R updateById(@RequestBody FddContractTemplateFile fddContractTemplateFile) {
        return R.ok(fddContractTemplateFileService.updateById(fddContractTemplateFile));
    }

    /**
     * 通过id删除法大大员工合同模板文件表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除法大大员工合同模板文件表", description = "通过id删除法大大员工合同模板文件表：hasPermission('demo_fddcontracttemplatefile_del')")
    @SysLog("通过id删除法大大员工合同模板文件表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_fddcontracttemplatefile_del')" )
    public R removeById(@PathVariable String id) {
        return R.ok(fddContractTemplateFileService.removeById(id));
    }

}
