/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddSealInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddSealInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 法大大印章
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/fddsealinfo" )
@Tag(name = "法大大印章管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class FddSealInfoController {

	private final FddSealInfoService fddSealInfoService;

	/**
	 * 分页查询
	 * @param fddSealInfo 法大大印章
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page" )
	public R<List<FddSealInfo>> getFddSealInfoPage(FddSealInfo fddSealInfo) {
		return R.ok(fddSealInfoService.getFddSealInfoPage(fddSealInfo));
	}

	/**
	 * 通过id查询法大大印章
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}" )
	public R getById(@PathVariable("id" ) String id) {
		return R.ok(fddSealInfoService.getById(id));
	}

	/**
	 * 新增法大大印章
	 * @param fddSealInfo 法大大印章
	 * @return R
	 */
	@Operation(summary = "新增法大大印章", description = "新增法大大印章：hasPermission('demo_fddsealinfo_add')")
	@SysLog("新增法大大印章" )
	@PostMapping
	@PreAuthorize("@pms.hasPermission('demo_fddsealinfo_add')" )
	public R save(@RequestBody FddSealInfo fddSealInfo) {
		return R.ok(fddSealInfoService.save(fddSealInfo));
	}

	/**
	 * 修改法大大印章
	 * @param fddSealInfo 法大大印章
	 * @return R
	 */
	@Operation(summary = "修改法大大印章", description = "修改法大大印章：hasPermission('demo_fddsealinfo_edit')")
	@SysLog("修改法大大印章" )
	@PutMapping
	@PreAuthorize("@pms.hasPermission('demo_fddsealinfo_edit')" )
	public R updateById(@RequestBody FddSealInfo fddSealInfo) {
		return R.ok(fddSealInfoService.updateById(fddSealInfo));
	}

	/**
	 * 通过id删除法大大印章
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除法大大印章", description = "通过id删除法大大印章：hasPermission('demo_fddsealinfo_del')")
	@SysLog("通过id删除法大大印章" )
	@DeleteMapping("/{id}" )
	@PreAuthorize("@pms.hasPermission('demo_fddsealinfo_del')" )
	public R removeById(@PathVariable String id) {
		return R.ok(fddSealInfoService.removeById(id));
	}

	/**
	 * 印章授权
	 * @return R
	 */
	@Operation(summary = "印章授权", description = "印章授权")
	@SysLog("印章授权")
	@PostMapping("/sealAuth")
	public R<String> sealAuth(@RequestParam List<String> id, @RequestParam String fddPersonAccountId) throws ApiException {
		return fddSealInfoService.sealAuth(id, fddPersonAccountId);
	}

	/**
	 * 印章取消授权
	 * @return R
	 */
	@Operation(summary = "印章取消授权", description = "印章取消授权")
	@SysLog("印章取消授权")
	@PostMapping("/cancelSealAuth")
	public R<String> cancelSealAuth(@RequestParam List<String> id,@RequestParam String fddPersonAccountId) throws ApiException {
		return fddSealInfoService.cancelSealAuth(id, fddPersonAccountId);
	}
}
