/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCertRecord;
import com.yifu.cloud.plus.v1.yifu.archives.service.TCertRecordService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.CertRecordSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TCertRecordVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 证明开具记录表
 *
 * @author fxj
 * @date 2022-06-25 11:05:11
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tcertrecord" )
@Tag(name = "证明开具记录表管理")
public class TCertRecordController {

    private final TCertRecordService tCertRecordService;
	private final MenuUtil menuUtil;
    /**
     * 分页查询
     * @param page 分页对象
     * @param searchVo 证明开具记录表
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page" )
    //@PreAuthorize("@pms.hasPermission('demo_tcertrecord_get')" )
    public R<IPage<TCertRecord>> getTCertRecordPage(Page page, CertRecordSearchVo searchVo) {
		setAuth(searchVo);
		return R.ok(tCertRecordService.pageDiy(page, searchVo));
    }

	private void setAuth(CertRecordSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		if (Common.isNotNull(searchVo.getAuthSql()) && searchVo.getAuthSql().contains(CommonConstants.A_DEPT_ID)) {
			searchVo.setAuthSql(searchVo.getAuthSql().replace(CommonConstants.A_DEPT_ID, "dept_id"));
		}
		if (Common.isNotNull(searchVo.getAuthSql()) && searchVo.getAuthSql().contains(CommonConstants.A_CREATE_BY)) {
			searchVo.setAuthSql(searchVo.getAuthSql().replace(CommonConstants.A_CREATE_BY, "CREATE_BY"));
		}
	}

	/**
     * 不分页查询
     * @param searchVo 证明开具记录表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tcertrecord_get')" )
    public R<List<TCertRecord>> getTCertRecordNoPage(@RequestBody CertRecordSearchVo searchVo) {
		setAuth(searchVo);
        return R.ok(tCertRecordService.getTCertRecordNoPage(searchVo));
    }

    /**
     * 通过id查询证明开具记录表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tcertrecord_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tcertrecord_get')" )
    public R<TCertRecord> getById(@PathVariable("id" ) String id) {
        return R.ok(tCertRecordService.getById(id));
    }

	/**
	 * 通过员工ID查询证明开具记录相关信息
	 * @param id 项目档案ID
	 * @return R
	 */
	@GetMapping("/getCertRecordInfo" )
	public R<TCertRecordVo> getCertRecordInfo(@RequestParam(value = "id" ) String id) {
		return tCertRecordService.getCertRecordInfo(id);
	}

    /**
     * 新增证明开具记录表
     * @param tCertRecord 证明开具记录表
     * @return R
     */
    @Operation(summary = "新增证明开具记录表", description = "新增证明开具记录表：hasPermission('demo_tcertrecord_add')")
    @SysLog("新增证明开具记录表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tcertrecord_add')" )
    public R<Boolean> save(@RequestBody TCertRecord tCertRecord) {
        return R.ok(tCertRecordService.save(tCertRecord));
    }

    /**
     * 修改证明开具记录表
     * @param tCertRecord 证明开具记录表
     * @return R
     */
    @Operation(summary = "修改证明开具记录表", description = "修改证明开具记录表：hasPermission('demo_tcertrecord_edit')")
    @SysLog("修改证明开具记录表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tcertrecord_edit')" )
    public R<Boolean> updateById(@RequestBody TCertRecord tCertRecord) {
        return R.ok(tCertRecordService.updateById(tCertRecord));
    }

    /**
     * 通过id删除证明开具记录表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除证明开具记录表", description = "通过id删除证明开具记录表：hasPermission('demo_tcertrecord_del')")
    @SysLog("通过id删除证明开具记录表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tcertrecord_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tCertRecordService.removeById(id));
    }

}
