/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitorSetBaseInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TCompleteMonitorSetBaseInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 完整度监控配置
 *
 * @author hgw
 * @date 2025-02-26 15:18:51
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tcompletemonitorsetbaseinfo")
@Tag(name = "完整度监控配置管理")
public class TCompleteMonitorSetBaseInfoController {

	private final TCompleteMonitorSetBaseInfoService tCompleteMonitorSetBaseInfoService;

	/**
	 * @param baseType 类型（1档案基础信息2默认联动信息3监控信息项）
	 * @Description: 获取list数据
	 * @Author: hgw
	 * @Date: 2025/2/27 11:49
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitorSetBaseInfo>>
	 **/
	@Operation(summary = "获取list数据", description = "不分页查询")
	@GetMapping("/getListByBaseType")
	public R<List<TCompleteMonitorSetBaseInfo>> getListByBaseType(@RequestParam(required = false) String baseType) {
		return R.ok(tCompleteMonitorSetBaseInfoService.getListByBaseType(baseType));
	}

	/**
	 * @param typeName 员工合同名称
	 * @Description: 根据员工合同名称，获取需要完整的字段
	 * @Author: hgw
	 * @Date: 2025/2/27 11:49
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitorSetBaseInfo>>
	 **/
	@Operation(summary = "根据员工合同名称，获取需要完整的字段", description = "根据员工合同名称，获取需要完整的字段")
	@GetMapping("/getBaseFieldByTypeName")
	public R<List<String>> getBaseFieldByTypeName(@RequestParam String typeName) {
		return R.ok(tCompleteMonitorSetBaseInfoService.getBaseFieldByTypeName(typeName));
	}

}
