package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TContractAutoLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.TContractAutoLogService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 合同自动化企微日志表
 *
 * @author huych
 * @date 2025-10-20 20:02:08
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tcontractautolog" )
@Tag(name = "合同自动化企微日志表管理")
public class TContractAutoLogController {

    private final  TContractAutoLogService tContractAutoLogService;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tContractAutoLog 合同自动化企微日志表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TContractAutoLog>> getTContractAutoLogPage(Page<TContractAutoLog> page, TContractAutoLog tContractAutoLog) {
        return new R<>(tContractAutoLogService.getTContractAutoLogPage(page,tContractAutoLog));
    }
	/**
	 * 通过id查询客户信息
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<TContractAutoLog> getById(@PathVariable("id") String id) {
		return R.ok(tContractAutoLogService.getById(id));
	}

}
