/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TWorkHandlerInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TWorkHandlerInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TWorkHandlerInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.InsertWorkHandlerVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;


/**
 * 任务处理清单表
 *
 * @author huyc
 * @date 2023-06-15 12:18:28
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tworkhandlerinfo")
@Tag(name = "任务处理清单表管理")
public class TWorkHandlerInfoController {

	private final TWorkHandlerInfoService tWorkHandlerInfoService;

	/**
	 * 简单分页查询
	 *
	 * @param page             分页对象
	 * @param tWorkHandlerInfo 任务处理清单表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TWorkHandlerInfo>> getTWorkHandlerInfoPage(Page<TWorkHandlerInfo> page, TWorkHandlerInfoSearchVo tWorkHandlerInfo) {
		return new R<>(tWorkHandlerInfoService.getTWorkHandlerInfoPage(page, tWorkHandlerInfo));
	}

	/**
	 * 通过id查询任务处理清单表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tworkhandlerinfo_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tworkhandlerinfo_get')")
	public R<TWorkHandlerInfo> getById(@PathVariable("id") String id) {
		return R.ok(tWorkHandlerInfoService.getById(id));
	}

	/**
	 * 任务处理清单表 批量导出
	 *
	 * @author huyc
	 * @date 2023-06-15 12:18:28
	 **/
	@Operation(description = "导出任务处理清单表 hasPermission('archives_tworkhandlerinfo-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('archives_tworkhandlerinfo-export')")
	public void export(HttpServletResponse response, @RequestBody TWorkHandlerInfoSearchVo searchVo) {
		tWorkHandlerInfoService.listExport(response, searchVo);
	}

	/**
	 * 新增任务处理表
	 * @author huyc
	 * @date 2023-06-25 12:18:28
	 **/
	@Operation(description = "新增任务处理表)")
	@Inner
	@PostMapping("/inner/insertWorkHandler")
	public Boolean insertWorkHandler(@RequestBody InsertWorkHandlerVo vo) {
		return tWorkHandlerInfoService.insertWorkHandler(vo);
	}
}
