/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractAreaRes;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmpContractAreaExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractAreaResSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 合同地市权限配置表
 *
 * @author fxj
 * @date 2022-11-01 10:30:12
 */
@Mapper
public interface TEmployeeContractAreaResMapper extends BaseMapper<TEmployeeContractAreaRes> {
    /**
     * 合同地市权限配置表简单分页查询
     * @param tEmployeeContractAreaRes 合同地市权限配置表
     * @return
     */
    IPage<TEmployeeContractAreaRes> getTEmployeeContractAreaResPage(Page<TEmployeeContractAreaRes> page, @Param("tEmployeeContractAreaRes") TEmployeeContractAreaRes tEmployeeContractAreaRes);

    List<TEmpContractAreaExportVo> noPageDiy(@Param("tEmployeeContractAreaRes") TEmployeeContractAreaResSearchVo searchVo,
											 @Param("settleDomainIds")List<String> settleDomains,
											 @Param("idsStr") List<String> idsStr,
											 @Param("sql")String sql);

	int noPageCountDiy(@Param("tEmployeeContractAreaRes") TEmployeeContractAreaResSearchVo searchVo,
					   @Param("settleDomainIds")List<String> settleDomains,
					   @Param("idsStr") List<String> idsStr,
					   @Param("sql")String sql);
}
