/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascTemplate;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TFascTemplateExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TFascTemplateSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 法大大专业版模板表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Mapper
public interface TFascTemplateMapper extends BaseMapper<TFascTemplate> {
    /**
     * 法大大专业版模板表简单分页查询
     * @param tFascTemplate 法大大专业版模板表
     * @return
     */
    IPage<TFascTemplate> getTFascTemplatePage(Page<TFascTemplate> page, @Param("tFascTemplate") TFascTemplate tFascTemplate);

    List<TFascTemplate> getTFascTemplateListAll(@Param("tFascTemplate") TFascTemplate tFascTemplate);
    List<TFascTemplate> getTFascTemplateList(@Param("tFascTemplate") TFascTemplate tFascTemplate);

	List<TFascTemplateExportVo> getTFascTemplateExport(@Param("tFascTemplate") TFascTemplateSearchVo tFascTemplate, @Param("idList") List<String> idList);

	/**
	 * @param
	 * @Description: 获取所有要更新是否必填的模板数据
	 * @Author: hgw
	 * @Date: 2025/10/9 18:59
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TFascTemplate>
	 **/
	List<TFascTemplate> getTFascTemplateResutList(@Param("templateId") String templateId);

}
