package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TProveRecord;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author pwang
 * @date 2019-11-05 15:24:25
 */
@Mapper
public interface TProveRecordMapper extends BaseMapper<TProveRecord> {
	/**
	 * 简单分页查询
	 *
	 * @param tProveRecord
	 * @return
	 */
	IPage<TProveRecord> getTProveRecordPage(Page page, @Param("tProveRecord") TProveRecord tProveRecord);


	/**
	 * @param tProveRecord
	 * @Description: 导出查条数
	 * @Author: hgw
	 * @Date: 2023/2/22 14:56
	 * @return: int
	 **/
	int getCountByExport(@Param("tProveRecord") TProveRecord tProveRecord);
	/**
	 * @param tProveRecord
	 * @Description: 导出list
	 * @Author: hgw
	 * @Date: 2023/2/22 14:56
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TProveRecord>
	 **/
	List<TProveRecord> getRecordInfoNoPage(@Param("tProveRecord") TProveRecord tProveRecord);

	Integer createNo(@Param("str") String str);
}
