/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoEmpRuleInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoEmpRuleInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 档案管理规则配置表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
public interface TAutoEmpRuleInfoService extends IService<TAutoEmpRuleInfo> {
    /**
     * 档案管理规则配置表简单分页查询
     * @param tAutoEmpRuleInfo 档案管理规则配置表
     * @return
     */
    IPage<TAutoEmpRuleInfo> getTAutoEmpRuleInfoPage(Page<TAutoEmpRuleInfo> page, TAutoEmpRuleInfoSearchVo tAutoEmpRuleInfo);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TAutoEmpRuleInfoSearchVo searchVo);

    List<TAutoEmpRuleInfo> noPageDiy(TAutoEmpRuleInfoSearchVo searchVo);
}
