/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpFamily;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpFamilyExcelVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.FamilySearchVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.io.InputStream;
import java.util.List;

/**
 * 员工家庭信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
public interface TEmpFamilyService extends IService<TEmpFamily> {

    void importEmpFamily(List<EmpFamilyExcelVO> excelVOList,List<ErrorMessage> errorMessageList);

	String checkRepeat(String empIdcard, String familyName, String updateId);

    R<Boolean> removeByIdsDiy(List<String> idList);

	IPage<TEmpFamily> pageDiy(Page page, FamilySearchVO tEmpFamily);

	List<TEmpFamily> getTEmpFamilyNoPage(FamilySearchVO family);

    R<List<ErrorMessage>> importEmpFamilyDiy(InputStream fileInputStream);

	/**
	 * @param empId
	 * @Description: 删除档案附属表信息（预入职清空附属信息专用，其余的请慎用）
	 * @Author: hgw
	 * @Date: 2024/6/19 18:27
	 * @return: void
	 **/
	void deleteByEmpId(String empId);

	List<TEmpFamily> getListByEmpId(String empId);

}
