package com.yifu.cloud.plus.v1.business.dto.vacation;


import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @description: 假期监控清零日志表 新增或更新记录dto
 * @author: wangweiguo
 * @date: 2021-08-16
*/

@Setter
@Getter
@ToString
public class AddVacationMonitorClearLogDTO implements Serializable  {
    /**
     * 年假监控id
     */
    @NotNull(message = "年假监控id不能为空")
	@Schema(description = "年假监控id")
	private String vacationMonitorId;

    /**
     * 清零说明
     */
	@Schema(description = "清零说明")
	private String clearNote;
}

