package com.yifu.cloud.plus.v1.business.entity.cert;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_update_record")
@Schema(description = "B端修改记录表")
public class TUpdateRecord extends Model<TUpdateRecord> {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键", name = "id")
    private String id;
    /**
     * 创建人id
     */
    @Length(max = 32, message = "创建人id不能超过32个字符")
    @ExcelAttribute(name = "创建人id", isNotEmpty = true, errorInfo = "创建人id不能为空", maxLength = 32)
    @Schema(description = "创建人id", name = "createUser")
    private String createUser;
    /**
     * 创建人名
     */
    @Length(max = 32, message = "创建人名不能超过32个字符")
    @ExcelAttribute(name = "创建人名", isNotEmpty = true, errorInfo = "创建人名不能为空", maxLength = 32)
    @Schema(description = "创建人名", name = "createUserName")
    private String createUserName;
    /**
     * 创建时间
     */
    @ExcelAttribute(name = "创建时间")
    @Schema(description = "创建时间", name = "createTime")
    private LocalDateTime createTime;
    /**
     * 实体id
     */
    @Length(max = 32, message = "实体id不能超过32个字符")
    @ExcelAttribute(name = "实体id", isNotEmpty = true, errorInfo = "实体id不能为空", maxLength = 32)
    @Schema(description = "实体id", name = "domainId")
    private String domainId;
    /**
     * 模块0证件
     */
    @NotBlank(message = "模块0证件不能为空")
    @Length(max = 2, message = "模块0证件不能超过2个字符")
    @ExcelAttribute(name = "模块0证件", isNotEmpty = true, errorInfo = "模块0证件不能为空", maxLength = 2)
    @Schema(description = "模块0证件", name = "modul")
    private String modul;
    /**
     * 全类名
     */
    @Length(max = 100, message = "全类名不能超过100个字符")
    @ExcelAttribute(name = "全类名", maxLength = 100)
    @Schema(description = "全类名", name = "fullClassName")
    private String fullClassName;
    /**
     * 原来的信息
     */
    @NotBlank(message = "原来的信息不能为空")
    @ExcelAttribute(name = "原来的信息", isNotEmpty = true, errorInfo = "原来的信息不能为空")
    @Schema(description = "原来的信息", name = "oldInfo")
    private String oldInfo;
    /**
     * 新的信息
     */
    @NotBlank(message = "新的信息不能为空")
    @ExcelAttribute(name = "新的信息", isNotEmpty = true, errorInfo = "新的信息不能为空")
    @Schema(description = "新的信息", name = "newInfo")
    private String newInfo;
    /**
     * 差异的信息
     */
    @ExcelAttribute(name = "差异的信息")
    @Schema(description = "差异的信息", name = "differenceInfo")
    private String differenceInfo;
}
