package com.yifu.cloud.plus.v1.business.entity.salary;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * B端-薪资配置
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_salary_config")
@Schema(description = "B端-薪资配置")
public class TBusSalaryConfig extends Model<TBusSalaryConfig> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 中文名（Excel表头）
      */
     @NotBlank(message = "中文名（Excel表头）不能为空")
     @Length(max = 32, message = "中文名（Excel表头）不能超过32个字符")
     @ExcelAttribute(name = "中文名（Excel表头）", isNotEmpty = true, errorInfo = "中文名（Excel表头）不能为空", maxLength = 32)
     @Schema(description = "中文名（Excel表头）")
     private String cnName;
     /**
      * 数据库字段名
      */
     @Length(max = 32, message = "数据库字段名不能超过32个字符")
     @ExcelAttribute(name = "数据库字段名", maxLength = 32)
     @Schema(description = "数据库字段名")
     private String dbFiedName;
     /**
      * JAVA属性字段名
      */
     @Length(max = 32, message = "JAVA属性字段名不能超过32个字符")
     @ExcelAttribute(name = "JAVA属性字段名", maxLength = 32)
     @Schema(description = "JAVA属性字段名")
     private String javaFiedName;
     /**
      * 校验字段：0：无所谓；1必填；2金额；3必填+金额
      */
     @ExcelAttribute(name = "校验字段：0：无所谓；1必填；2金额；3必填+金额", maxLength = 1)
     @Schema(description = "校验字段：0：无所谓；1必填；2金额；3必填+金额")
     private Integer isMustNeed;
     /**
      * 创建人
      */
     @NotBlank(message = "创建人不能为空")
     @Length(max = 32, message = "创建人不能超过32个字符")
     @ExcelAttribute(name = "创建人", isNotEmpty = true, errorInfo = "创建人不能为空", maxLength = 32)
     @Schema(description = "创建人")
     private String createUser;
     /**
      * 创建时间
      */
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createTime;
     /**
      * 排序项
      */
     @ExcelAttribute(name = "排序项")
     @Schema(description = "排序项")
     private Integer orderLine;
}
