package com.yifu.cloud.plus.v1.business.entity.salary;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * B端-薪酬明细表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_salary_item")
@Schema(description = "B端-薪酬明细表")
public class TBusSalaryItem extends Model<TBusSalaryItem> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 工资报账表ID
      */
     @NotBlank(message = "工资报账表ID不能为空")
     @Length(max = 32, message = "工资报账表ID不能超过32个字符")
     @ExcelAttribute(name = "工资报账表ID", isNotEmpty = true, errorInfo = "工资报账表ID不能为空", maxLength = 32)
     @Schema(description = "工资报账表ID")
     private String salaryId;
     /**
      * 表头名称
      */
     @NotBlank(message = "表头名称不能为空")
     @Length(max = 50, message = "表头名称不能超过50个字符")
     @ExcelAttribute(name = "表头名称", isNotEmpty = true, errorInfo = "表头名称不能为空", maxLength = 50)
     @Schema(description = "表头名称")
     private String cnName;
     /**
      * JAVA属性名称
      */
     @NotBlank(message = "JAVA属性名称不能为空")
     @Length(max = 32, message = "JAVA属性名称不能超过32个字符")
     @ExcelAttribute(name = "JAVA属性名称", isNotEmpty = true, errorInfo = "JAVA属性名称不能为空", maxLength = 32)
     @Schema(description = "JAVA属性名称")
     private String javaFiedName;
     /**
      * 文本值
      */
     @Length(max = 100, message = "文本值不能超过100个字符")
     @ExcelAttribute(name = "文本值", maxLength = 100)
     @Schema(description = "文本值")
     private String textValue;

     /**
      * 排序项
      */
     @ExcelAttribute(name = "排序项")
     @Schema(description = "排序项")
     private Integer orderLine;
}
