package com.yifu.cloud.plus.v1.business.entity.system;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * B端短信发送记录表
 *
 * @author hgw
 * @date 2021-08-23 16:27:34
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_warning_employee")
@Schema(description = "B端短信发送记录表")
public class TBusWarningEmployee extends Model<TBusWarningEmployee> {
     private static final long serialVersionUID = 1L;
     /**
      *
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键", name = "id")
     private Integer id;
     /**
      * 预警主表id
      */
     @NotBlank(message = "预警主表id不能为空")
     @Length(max = 32, message = "预警主表id不能超过32个字符")
     @ExcelAttribute(name = "预警主表id", isNotEmpty = true, errorInfo = "预警主表id不能为空", maxLength = 32)
     @Schema(description = "预警主表id")
     private String warningId;
     /**
      * 客户id
      */
     @Length(max = 32, message = "B端部门id不能超过32个字符")
     @ExcelAttribute(name = "B端部门id", maxLength = 32)
     @Schema(description = "B端部门id")
     private String busDeptId;
     /**
      * 客户编码
      */
     @Length(max = 32, message = "B端部门编码不能超过32个字符")
     @ExcelAttribute(name = "B端部门编码", maxLength = 32)
     @Schema(description = "B端部门编码")
     private String busDeptCode;
     /**
      * 客户名称
      */
     @Length(max = 50, message = "B端部门名称不能超过50个字符")
     @ExcelAttribute(name = "B端部门名称", maxLength = 50)
     @Schema(description = "B端部门名称")
     private String busDeptName;
     /**
      * 姓名
      */
     @Length(max = 32, message = "姓名不能超过32个字符")
     @ExcelAttribute(name = "姓名", maxLength = 32)
     @Schema(description = "姓名")
     private String empName;
     /**
      * 身份证
      */
     @Length(max = 50, message = "身份证不能超过50个字符")
     @ExcelAttribute(name = "身份证", maxLength = 50)
     @Schema(description = "身份证")
     private String empIdcard;
     /**
      * 联系方式
      */
     @Length(max = 50, message = "联系方式不能超过50个字符")
     @ExcelAttribute(name = "联系方式", maxLength = 50)
     @Schema(description = "联系方式")
     private String empPhone;
     /**
      * 发送时间
      */
     @ExcelAttribute(name = "发送时间")
     @Schema(description = "发送时间")
     private LocalDateTime sendDate;
     /**
      * 创建人
      */
     @Length(max = 32, message = "创建人不能超过32个字符")
     @ExcelAttribute(name = "创建人", maxLength = 32)
     @Schema(description = "创建人")
     private String createUser;
     /**
      * 发送状态：1等待回执;2：发送失败;3：发送成功;
      */
     @Length(max = 1, message = "发送状态：1等待回执;2：发送失败;3：发送成功;不能超过1个字符")
     @ExcelAttribute(name = "发送状态：1等待回执;2：发送失败;3：发送成功;", maxLength = 1)
     @Schema(description = "发送状态：1等待回执;2：发送失败;3：发送成功;")
     private String sendStatus;
     /**
      * 备注
      */
     @Length(max = 100, message = "备注不能超过100个字符")
     @ExcelAttribute(name = "备注", maxLength = 100)
     @Schema(description = "备注")
     private String remark;
     /**
      * 回执id
      */
     @Length(max = 50, message = "回执id不能超过50个字符")
     @ExcelAttribute(name = "回执id", maxLength = 50)
     @Schema(description = "回执id")
     private String bizId;
     /**
      * 短信状态是否回执
      */
     @Length(max = 1, message = "短信状态是否回执不能超过1个字符")
     @ExcelAttribute(name = "短信状态是否回执", maxLength = 1)
     @Schema(description = "短信状态是否回执")
     private String updateStatus;
     /**
      * 短信回执内容
      */
     @Length(max = 100, message = "短信回执内容不能超过100个字符")
     @ExcelAttribute(name = "短信回执内容", maxLength = 100)
     @Schema(description = "短信回执内容")
     private String message;

     /**
      * 证件类型（中文）
      */
     @Length(max = 100, message = "证件类型（中文）不能超过100个字符")
     @ExcelAttribute(name = "证件类型（中文）", maxLength = 100)
     @Schema(description = "证件类型（中文）")
     private String certType;

     /**
      * 未使用假期时长
      */
     @ExcelAttribute(name = "未使用假期时长")
     @Schema(description = "未使用假期时长")
     private String notUsedVacationDuration;

     /**
      * 电信工号
      */
     @ExcelAttribute(name = "电信工号", maxLength = 32)
     @Schema(description = "电信工号")
     private String businessTelecomNumber;

     @TableField(exist = false)
     @Schema(description = "发送时间起：例如2021-08-26")
     private String sendDateStart;

     @TableField(exist = false)
     @Schema(description = "发送时间止：例如2021-08-26")
     private String sendDateEnd;
}
