package com.yifu.cloud.plus.v1.business.query.salary;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @description: 部门薪资变动统计表 查询query
 * @author: wangweiguo
 * @date: 2021-09-06
*/
@Setter
@Getter
@ToString
public class TSalaryStatisticsDepartQuery implements Serializable  {
    /**
     * 部门treeLogo
     */
    @Schema(description ="部门treeLogo")
    @NotBlank(message = "部门treeLogo不能为空")
    private String treeLogo;

    /**
     * 工资月份
     */
    @Schema(description = "工资月份 yyyyMM", required = true)
    @NotBlank(message = "查询条件: 工资月份不能为空")
    private String salaryMonth;

    /**
     * 部门等级
     */
    @Schema(description = "部门等级")
    @NotNull(message = "部门等级不能为空")
    private Integer departLevel;

    /**
     * 工资月份的上个月
     */
    @Schema(description = "工资月份的上个月，前端无需传该参数")
    private String lastSalaryMonth;

    /**
     * 变动类型 0应发增加,
     * 1应发减少,
     * 2应发不变,
     * 3实发增加,
     * 4实发减少,
     * 5实发不变,
     * 6人均成本增加,
     * 7人均成本减少,
     * 8人均成本不变,
     * 9扣款增加,
     * 10扣款减少,
     * 11扣款不变
     */
    @Schema(description ="变动类型: 0应发增加, 1应发减少, 2应发不变, 3实发增加, 4实发减少, 5实发不变, 6人均成本增加, 7人均成本减少, 8人均成本不变, 9扣款增加, 10扣款减少, 11扣款不变")
    private String salaryChangeType;

}

