package com.yifu.cloud.plus.v1.business.controller.salary;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalary;
import com.yifu.cloud.plus.v1.business.service.salary.TBusSalaryService;
import com.yifu.cloud.plus.v1.business.vo.salary.BusSalaryExportVo;
import com.yifu.cloud.plus.v1.business.vo.salary.SalaryImportVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


/**
 * B端-薪酬主表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tbussalary")
@Tag(name = "B端-薪酬主表")
public class TBusSalaryController {

     private final TBusSalaryService tBusSalaryService;

     /**
      * 简单分页查询
      *
      * @param page       分页对象
      * @param tBusSalary B端-薪酬主表
      * @return
      */
     @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TBusSalary>> getTBusSalaryPage(Page<TBusSalary> page, TBusSalary tBusSalary) {
          return new R<>(tBusSalaryService.getTBusSalaryPage(page, tBusSalary));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TBusSalary> getById(@PathVariable("id") String id) {
          return new R<>(tBusSalaryService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tBusSalary
      * @return R
      */
     @Operation(summary = "新增(yifu-hro-business:tbussalary_add)")
     @PostMapping
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalary_add')")
     public R<Boolean> save(@Valid @RequestBody TBusSalary tBusSalary) {
          return new R<>(tBusSalaryService.save(tBusSalary));
     }

     /**
      * 修改记录
      *
      * @param tBusSalary
      * @return R
      */
     @Operation(summary = "修改(yifu-hro-business:tbussalary_edit)")
     @SysLog("修改B端-薪酬主表")
     @PutMapping
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalary_edit')")
     public R<Boolean> update(@RequestBody TBusSalary tBusSalary) {
          return new R<>(tBusSalaryService.updateById(tBusSalary));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(summary = "删除(yifu-hro-business:tbussalary_del)")
     @SysLog("删除B端-薪酬主表")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalary_del')")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tBusSalaryService.removeById(id));
     }

     /**
      * 通过id删除一条记录
      *
      * @return R
      */
     @Operation(summary = "删除-根据部门与月份(yifu-hro-business:tbussalary_delete)")
     @SysLog("删除B端-薪酬主表-根据部门与月份")
     @PostMapping("/deleteByDeptAndMonth")
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalary_delete')")
     public R<String> deleteByDeptAndMonth(String idStr, Integer deptId, String salaryMonth) {
          if (Common.isEmpty(idStr) && Common.isEmpty(deptId)) {
               return R.failed("请传参!");
          }
          int count = 0;
          if (Common.isNotNull(idStr)) {
               String[] idArr = idStr.split(",");
               for (String id : idArr) {
                    if (tBusSalaryService.removeById(id)) {
                         count++;
                    }
               }
          } else if (Common.isNotNull(deptId) && Common.isNotNull(salaryMonth)) {
               TBusSalary busSalary = new TBusSalary();
               busSalary.setDeptId(deptId);
               busSalary.setSalaryMonth(salaryMonth);
               QueryWrapper<TBusSalary> queryWrapperSa = new QueryWrapper<>();
               queryWrapperSa.setEntity(busSalary);
               count = (int) tBusSalaryService.count(queryWrapperSa);
               tBusSalaryService.remove(queryWrapperSa);
          }
          if (count == 0) {
               return R.failed("无数据可删除！");
          }
          return R.ok("已删除：" + count + "条数据！");
     }

     /**
      * @param salaryVo
      * @Description: 导入
      * @Author: hgw/
      * @Date: 2021/9/6 16:23
      * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
      **/
     @Operation(summary = "导入表格数据：contentList：表格数据list；deptId：部门id；salaryMonth：工资月份；resList：配置关系list；saveType：保存类型：0:保存；1不保存")
     @SysLog("B端导入表格数据")
     @PostMapping("/importBusSalary")
     public R<List<ErrorMessage>> importBusSalary(@RequestBody SalaryImportVo salaryVo) {
          return tBusSalaryService.importBusSalary(salaryVo);
     }

     /**
      * 简单分页查询
      * @param tBusSalary B端-薪酬主表
      */
     @Operation(summary = "导出")
     @PostMapping("/doExport")
     public R<BusSalaryExportVo> doExport(@RequestBody TBusSalary tBusSalary) {
          return new R<>(tBusSalaryService.doExport(tBusSalary));
     }

}
